# SageOne\TransactionTypesApi

All URIs are relative to https://api.accounting.sage.com/v3.1.

Method | HTTP request | Description
------------- | ------------- | -------------
[**getTransactionTypes()**](TransactionTypesApi.md#getTransactionTypes) | **GET** /transaction_types | Returns all Transaction Types
[**getTransactionTypesKey()**](TransactionTypesApi.md#getTransactionTypesKey) | **GET** /transaction_types/{key} | Returns a Transaction Type


## `getTransactionTypes()`

```php
getTransactionTypes($show_legacy_id, $items_per_page, $page, $attributes): \SageOne\Model\PagingBase
```

Returns all Transaction Types

Returns all Transaction Types

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\TransactionTypesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$show_legacy_id = True; // bool | Display the legacy_id for the Transaction Types.
$items_per_page = 20; // int | Returns the given number of Transaction Types per request.
$page = 1; // int | Go to specific page of Transaction Types
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Transaction Types (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getTransactionTypes($show_legacy_id, $items_per_page, $page, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TransactionTypesApi->getTransactionTypes: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **show_legacy_id** | **bool**| Display the legacy_id for the Transaction Types. | [optional]
 **items_per_page** | **int**| Returns the given number of Transaction Types per request. | [optional] [default to 20]
 **page** | **int**| Go to specific page of Transaction Types | [optional] [default to 1]
 **attributes** | **string**| Specify the attributes that you want to expose for the Transaction Types (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\PagingBase**](../Model/PagingBase.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getTransactionTypesKey()`

```php
getTransactionTypesKey($key, $show_legacy_id, $attributes): \SageOne\Model\Base
```

Returns a Transaction Type

Returns a Transaction Type

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\TransactionTypesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Transaction Type Key.
$show_legacy_id = True; // bool | Display the legacy_id for the Transaction Type.
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Transaction Type (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getTransactionTypesKey($key, $show_legacy_id, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TransactionTypesApi->getTransactionTypesKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Transaction Type Key. |
 **show_legacy_id** | **bool**| Display the legacy_id for the Transaction Type. | [optional]
 **attributes** | **string**| Specify the attributes that you want to expose for the Transaction Type (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\Base**](../Model/Base.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
