# SageOne\TaxSchemesApi

All URIs are relative to https://api.accounting.sage.com/v3.1.

Method | HTTP request | Description
------------- | ------------- | -------------
[**getTaxSchemes()**](TaxSchemesApi.md#getTaxSchemes) | **GET** /tax_schemes | Returns all Tax Schemes
[**getTaxSchemesKey()**](TaxSchemesApi.md#getTaxSchemesKey) | **GET** /tax_schemes/{key} | Returns a Tax Scheme


## `getTaxSchemes()`

```php
getTaxSchemes($show_legacy_id, $items_per_page, $page, $attributes): \SageOne\Model\TaxScheme[]
```

Returns all Tax Schemes

Returns all Tax Schemes

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\TaxSchemesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$show_legacy_id = True; // bool | Display the legacy_id for the Tax Schemes.
$items_per_page = 20; // int | Returns the given number of Tax Schemes per request.
$page = 1; // int | Go to specific page of Tax Schemes
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Tax Schemes (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getTaxSchemes($show_legacy_id, $items_per_page, $page, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TaxSchemesApi->getTaxSchemes: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **show_legacy_id** | **bool**| Display the legacy_id for the Tax Schemes. | [optional]
 **items_per_page** | **int**| Returns the given number of Tax Schemes per request. | [optional] [default to 20]
 **page** | **int**| Go to specific page of Tax Schemes | [optional] [default to 1]
 **attributes** | **string**| Specify the attributes that you want to expose for the Tax Schemes (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\TaxScheme[]**](../Model/TaxScheme.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getTaxSchemesKey()`

```php
getTaxSchemesKey($key, $show_legacy_id, $attributes): \SageOne\Model\TaxScheme
```

Returns a Tax Scheme

Returns a Tax Scheme

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\TaxSchemesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Tax Scheme Key.
$show_legacy_id = True; // bool | Display the legacy_id for the Tax Scheme.
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Tax Scheme (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getTaxSchemesKey($key, $show_legacy_id, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TaxSchemesApi->getTaxSchemesKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Tax Scheme Key. |
 **show_legacy_id** | **bool**| Display the legacy_id for the Tax Scheme. | [optional]
 **attributes** | **string**| Specify the attributes that you want to expose for the Tax Scheme (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\TaxScheme**](../Model/TaxScheme.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
