# SageOne\TaxReturnFrequenciesApi

All URIs are relative to https://api.accounting.sage.com/v3.1.

Method | HTTP request | Description
------------- | ------------- | -------------
[**getTaxReturnFrequencies()**](TaxReturnFrequenciesApi.md#getTaxReturnFrequencies) | **GET** /tax_return_frequencies | Returns all Tax Return Frequencies
[**getTaxReturnFrequenciesKey()**](TaxReturnFrequenciesApi.md#getTaxReturnFrequenciesKey) | **GET** /tax_return_frequencies/{key} | Returns a Tax Return Frequency


## `getTaxReturnFrequencies()`

```php
getTaxReturnFrequencies($tax_type_id, $show_legacy_id, $items_per_page, $page, $attributes): \SageOne\Model\Base[]
```

Returns all Tax Return Frequencies

Returns all Tax Return Frequencies

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\TaxReturnFrequenciesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$tax_type_id = 'tax_type_id_example'; // string | Use this to filter Tax Submission Frequency Types by tax_type_id (Canada only)
$show_legacy_id = True; // bool | Display the legacy_id for the Tax Submission Frequency Types.
$items_per_page = 20; // int | Returns the given number of Tax Submission Frequency Types per request.
$page = 1; // int | Go to specific page of Tax Submission Frequency Types
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Tax Submission Frequency Types (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getTaxReturnFrequencies($tax_type_id, $show_legacy_id, $items_per_page, $page, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TaxReturnFrequenciesApi->getTaxReturnFrequencies: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **tax_type_id** | **string**| Use this to filter Tax Submission Frequency Types by tax_type_id (Canada only) | [optional]
 **show_legacy_id** | **bool**| Display the legacy_id for the Tax Submission Frequency Types. | [optional]
 **items_per_page** | **int**| Returns the given number of Tax Submission Frequency Types per request. | [optional] [default to 20]
 **page** | **int**| Go to specific page of Tax Submission Frequency Types | [optional] [default to 1]
 **attributes** | **string**| Specify the attributes that you want to expose for the Tax Submission Frequency Types (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\Base[]**](../Model/Base.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getTaxReturnFrequenciesKey()`

```php
getTaxReturnFrequenciesKey($key, $show_legacy_id, $attributes): \SageOne\Model\Base
```

Returns a Tax Return Frequency

Returns a Tax Return Frequency

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\TaxReturnFrequenciesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Tax Return Frequency Key.
$show_legacy_id = True; // bool | Display the legacy_id for the Tax Submission Frequency Type.
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Tax Submission Frequency Type (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getTaxReturnFrequenciesKey($key, $show_legacy_id, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TaxReturnFrequenciesApi->getTaxReturnFrequenciesKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Tax Return Frequency Key. |
 **show_legacy_id** | **bool**| Display the legacy_id for the Tax Submission Frequency Type. | [optional]
 **attributes** | **string**| Specify the attributes that you want to expose for the Tax Submission Frequency Type (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\Base**](../Model/Base.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
