# SageOne\TaxRatesApi

All URIs are relative to https://api.accounting.sage.com/v3.1.

Method | HTTP request | Description
------------- | ------------- | -------------
[**deleteTaxRatesKey()**](TaxRatesApi.md#deleteTaxRatesKey) | **DELETE** /tax_rates/{key} | Deletes a Tax Rate (US only)
[**getTaxRates()**](TaxRatesApi.md#getTaxRates) | **GET** /tax_rates | Returns all Tax Rates
[**getTaxRatesKey()**](TaxRatesApi.md#getTaxRatesKey) | **GET** /tax_rates/{key} | Returns a Tax Rate
[**postTaxRates()**](TaxRatesApi.md#postTaxRates) | **POST** /tax_rates | Creates a Tax Rate (US only)
[**putTaxRatesKey()**](TaxRatesApi.md#putTaxRatesKey) | **PUT** /tax_rates/{key} | Updates a Tax Rate (US only)


## `deleteTaxRatesKey()`

```php
deleteTaxRatesKey($key)
```

Deletes a Tax Rate (US only)

Deletes a Tax Rate (US only)

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\TaxRatesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Tax Rate key.

try {
    $apiInstance->deleteTaxRatesKey($key);
} catch (Exception $e) {
    echo 'Exception when calling TaxRatesApi->deleteTaxRatesKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Tax Rate key. |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getTaxRates()`

```php
getTaxRates($updated_or_created_since, $address_region_id, $date, $show_legacy_id, $items_per_page, $page, $attributes): \SageOne\Model\PagingTaxRate
```

Returns all Tax Rates

Returns all Tax Rates

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\TaxRatesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$updated_or_created_since = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | Use this to limit the response to Tax Rates changed since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Inclusive of the passed timestamp.
$address_region_id = 'address_region_id_example'; // string | Use this to filter by address region id
$date = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | Use this to return results on a specified date.
$show_legacy_id = True; // bool | Display the legacy_id for the Tax Rates.
$items_per_page = 20; // int | Returns the given number of Tax Rates per request.
$page = 1; // int | Go to specific page of Tax Rates
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Tax Rates (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getTaxRates($updated_or_created_since, $address_region_id, $date, $show_legacy_id, $items_per_page, $page, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TaxRatesApi->getTaxRates: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **updated_or_created_since** | **\DateTime**| Use this to limit the response to Tax Rates changed since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Inclusive of the passed timestamp. | [optional]
 **address_region_id** | **string**| Use this to filter by address region id | [optional]
 **date** | **\DateTime**| Use this to return results on a specified date. | [optional]
 **show_legacy_id** | **bool**| Display the legacy_id for the Tax Rates. | [optional]
 **items_per_page** | **int**| Returns the given number of Tax Rates per request. | [optional] [default to 20]
 **page** | **int**| Go to specific page of Tax Rates | [optional] [default to 1]
 **attributes** | **string**| Specify the attributes that you want to expose for the Tax Rates (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\PagingTaxRate**](../Model/PagingTaxRate.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getTaxRatesKey()`

```php
getTaxRatesKey($key, $date, $show_legacy_id, $attributes): \SageOne\Model\TaxRate
```

Returns a Tax Rate

Returns a Tax Rate

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\TaxRatesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Tax Rate Key.
$date = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | Use this to show the tax rate percentage on the given date
$show_legacy_id = True; // bool | Display the legacy_id for the Tax Rate.
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Tax Rate (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getTaxRatesKey($key, $date, $show_legacy_id, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TaxRatesApi->getTaxRatesKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Tax Rate Key. |
 **date** | **\DateTime**| Use this to show the tax rate percentage on the given date | [optional]
 **show_legacy_id** | **bool**| Display the legacy_id for the Tax Rate. | [optional]
 **attributes** | **string**| Specify the attributes that you want to expose for the Tax Rate (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\TaxRate**](../Model/TaxRate.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `postTaxRates()`

```php
postTaxRates($tax_rates): \SageOne\Model\TaxRate
```

Creates a Tax Rate (US only)

Creates a Tax Rate (US only)

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\TaxRatesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$tax_rates = new \SageOne\Model\PostTaxRates(); // \SageOne\Model\PostTaxRates

try {
    $result = $apiInstance->postTaxRates($tax_rates);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TaxRatesApi->postTaxRates: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **tax_rates** | [**\SageOne\Model\PostTaxRates**](../Model/PostTaxRates.md)|  |

### Return type

[**\SageOne\Model\TaxRate**](../Model/TaxRate.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `putTaxRatesKey()`

```php
putTaxRatesKey($key, $tax_rates): \SageOne\Model\TaxRate
```

Updates a Tax Rate (US only)

Updates a Tax Rate (US only)

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\TaxRatesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Tax Rate key.
$tax_rates = new \SageOne\Model\PutTaxRates(); // \SageOne\Model\PutTaxRates

try {
    $result = $apiInstance->putTaxRatesKey($key, $tax_rates);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TaxRatesApi->putTaxRatesKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Tax Rate key. |
 **tax_rates** | [**\SageOne\Model\PutTaxRates**](../Model/PutTaxRates.md)|  |

### Return type

[**\SageOne\Model\TaxRate**](../Model/TaxRate.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
