# SageOne\TaxOfficesApi

All URIs are relative to https://api.accounting.sage.com/v3.1.

Method | HTTP request | Description
------------- | ------------- | -------------
[**getTaxOffices()**](TaxOfficesApi.md#getTaxOffices) | **GET** /tax_offices | Returns all Tax Offices
[**getTaxOfficesKey()**](TaxOfficesApi.md#getTaxOfficesKey) | **GET** /tax_offices/{key} | Returns a Tax Office


## `getTaxOffices()`

```php
getTaxOffices($show_legacy_id, $items_per_page, $page, $attributes): \SageOne\Model\TaxOffice[]
```

Returns all Tax Offices

Returns all Tax Offices

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\TaxOfficesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$show_legacy_id = True; // bool | Display the legacy_id for the Tax Offices.
$items_per_page = 20; // int | Returns the given number of Tax Offices per request.
$page = 1; // int | Go to specific page of Tax Offices
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Tax Offices (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getTaxOffices($show_legacy_id, $items_per_page, $page, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TaxOfficesApi->getTaxOffices: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **show_legacy_id** | **bool**| Display the legacy_id for the Tax Offices. | [optional]
 **items_per_page** | **int**| Returns the given number of Tax Offices per request. | [optional] [default to 20]
 **page** | **int**| Go to specific page of Tax Offices | [optional] [default to 1]
 **attributes** | **string**| Specify the attributes that you want to expose for the Tax Offices (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\TaxOffice[]**](../Model/TaxOffice.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getTaxOfficesKey()`

```php
getTaxOfficesKey($key, $show_legacy_id, $attributes): \SageOne\Model\TaxOffice
```

Returns a Tax Office

Returns a Tax Office

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\TaxOfficesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Tax Office Key.
$show_legacy_id = True; // bool | Display the legacy_id for the Tax Office.
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Tax Office (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getTaxOfficesKey($key, $show_legacy_id, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TaxOfficesApi->getTaxOfficesKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Tax Office Key. |
 **show_legacy_id** | **bool**| Display the legacy_id for the Tax Office. | [optional]
 **attributes** | **string**| Specify the attributes that you want to expose for the Tax Office (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\TaxOffice**](../Model/TaxOffice.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
