# SageOne\StockMovementsApi

All URIs are relative to https://api.accounting.sage.com/v3.1.

Method | HTTP request | Description
------------- | ------------- | -------------
[**deleteStockMovementsKey()**](StockMovementsApi.md#deleteStockMovementsKey) | **DELETE** /stock_movements/{key} | Deletes a Stock Movement
[**getStockMovements()**](StockMovementsApi.md#getStockMovements) | **GET** /stock_movements | Returns all Stock Movements
[**getStockMovementsKey()**](StockMovementsApi.md#getStockMovementsKey) | **GET** /stock_movements/{key} | Returns a Stock Movement
[**postStockMovements()**](StockMovementsApi.md#postStockMovements) | **POST** /stock_movements | Creates a Stock Movement
[**putStockMovementsKey()**](StockMovementsApi.md#putStockMovementsKey) | **PUT** /stock_movements/{key} | Updates a Stock Movement


## `deleteStockMovementsKey()`

```php
deleteStockMovementsKey($key)
```

Deletes a Stock Movement

Deletes a Stock Movement

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\StockMovementsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Stock Movement Key.

try {
    $apiInstance->deleteStockMovementsKey($key);
} catch (Exception $e) {
    echo 'Exception when calling StockMovementsApi->deleteStockMovementsKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Stock Movement Key. |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getStockMovements()`

```php
getStockMovements($search, $stock_item_id, $from_date, $to_date, $show_legacy_id, $items_per_page, $page, $attributes): \SageOne\Model\StockMovement[]
```

Returns all Stock Movements

Returns all Stock Movements

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\StockMovementsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$search = 'search_example'; // string | Use this to filter by the details
$stock_item_id = 'stock_item_id_example'; // string | Use this to filter  by stock_item_id
$from_date = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | Use this to filter by Stock Movements dates
$to_date = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | Use this to filter by Stock Movements dates
$show_legacy_id = True; // bool | Display the legacy_id for the Stock Movements.
$items_per_page = 20; // int | Returns the given number of Stock Movements per request.
$page = 1; // int | Go to specific page of Stock Movements
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Stock Movements (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getStockMovements($search, $stock_item_id, $from_date, $to_date, $show_legacy_id, $items_per_page, $page, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling StockMovementsApi->getStockMovements: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **search** | **string**| Use this to filter by the details | [optional]
 **stock_item_id** | **string**| Use this to filter  by stock_item_id | [optional]
 **from_date** | **\DateTime**| Use this to filter by Stock Movements dates | [optional]
 **to_date** | **\DateTime**| Use this to filter by Stock Movements dates | [optional]
 **show_legacy_id** | **bool**| Display the legacy_id for the Stock Movements. | [optional]
 **items_per_page** | **int**| Returns the given number of Stock Movements per request. | [optional] [default to 20]
 **page** | **int**| Go to specific page of Stock Movements | [optional] [default to 1]
 **attributes** | **string**| Specify the attributes that you want to expose for the Stock Movements (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\StockMovement[]**](../Model/StockMovement.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getStockMovementsKey()`

```php
getStockMovementsKey($key, $show_legacy_id, $attributes): \SageOne\Model\StockMovement
```

Returns a Stock Movement

Returns a Stock Movement

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\StockMovementsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Stock Movement Key.
$show_legacy_id = True; // bool | Display the legacy_id for the Stock Movement.
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Stock Movement (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getStockMovementsKey($key, $show_legacy_id, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling StockMovementsApi->getStockMovementsKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Stock Movement Key. |
 **show_legacy_id** | **bool**| Display the legacy_id for the Stock Movement. | [optional]
 **attributes** | **string**| Specify the attributes that you want to expose for the Stock Movement (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\StockMovement**](../Model/StockMovement.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `postStockMovements()`

```php
postStockMovements($stock_movements): \SageOne\Model\StockMovement
```

Creates a Stock Movement

Creates a Stock Movement

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\StockMovementsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$stock_movements = new \SageOne\Model\PostStockMovements(); // \SageOne\Model\PostStockMovements

try {
    $result = $apiInstance->postStockMovements($stock_movements);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling StockMovementsApi->postStockMovements: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **stock_movements** | [**\SageOne\Model\PostStockMovements**](../Model/PostStockMovements.md)|  |

### Return type

[**\SageOne\Model\StockMovement**](../Model/StockMovement.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `putStockMovementsKey()`

```php
putStockMovementsKey($key, $stock_movements): \SageOne\Model\StockMovement
```

Updates a Stock Movement

Updates a Stock Movement

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\StockMovementsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Stock Movement Key.
$stock_movements = new \SageOne\Model\PutStockMovements(); // \SageOne\Model\PutStockMovements

try {
    $result = $apiInstance->putStockMovementsKey($key, $stock_movements);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling StockMovementsApi->putStockMovementsKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Stock Movement Key. |
 **stock_movements** | [**\SageOne\Model\PutStockMovements**](../Model/PutStockMovements.md)|  |

### Return type

[**\SageOne\Model\StockMovement**](../Model/StockMovement.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
