# SageOne\StockItemsApi

All URIs are relative to https://api.accounting.sage.com/v3.1.

Method | HTTP request | Description
------------- | ------------- | -------------
[**deleteStockItemsKey()**](StockItemsApi.md#deleteStockItemsKey) | **DELETE** /stock_items/{key} | Deletes a Stock Item
[**getStockItems()**](StockItemsApi.md#getStockItems) | **GET** /stock_items | Returns all Stock Items
[**getStockItemsKey()**](StockItemsApi.md#getStockItemsKey) | **GET** /stock_items/{key} | Returns a Stock Item
[**postStockItems()**](StockItemsApi.md#postStockItems) | **POST** /stock_items | Creates a Stock Item
[**putStockItemsKey()**](StockItemsApi.md#putStockItemsKey) | **PUT** /stock_items/{key} | Updates a Stock Item


## `deleteStockItemsKey()`

```php
deleteStockItemsKey($key)
```

Deletes a Stock Item

Deletes a Stock Item

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\StockItemsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Stock Item Key.

try {
    $apiInstance->deleteStockItemsKey($key);
} catch (Exception $e) {
    echo 'Exception when calling StockItemsApi->deleteStockItemsKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Stock Item Key. |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getStockItems()`

```php
getStockItems($search, $updated_or_created_since, $deleted_since, $active, $out_of_stock, $below_reorder_level, $show_legacy_id, $items_per_page, $page, $attributes): \SageOne\Model\PagingStockItem
```

Returns all Stock Items

Returns all Stock Items

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\StockItemsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$search = 'search_example'; // string | Use this to filter by the item code or description.
$updated_or_created_since = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | Use this to limit the response to Stock Items changed since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Inclusive of the passed timestamp.
$deleted_since = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | Use this to limit the response to Stock Items deleted since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Not inclusive of the passed timestamp.
$active = True; // bool | Use this to only return active or inactive items
$out_of_stock = True; // bool | Use this to filter by the Stock Items that are out of stock
$below_reorder_level = True; // bool | Use this to filter by the Stock Items that are below the reorder level
$show_legacy_id = True; // bool | Display the legacy_id for the Stock Items.
$items_per_page = 20; // int | Returns the given number of Stock Items per request.
$page = 1; // int | Go to specific page of Stock Items
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Stock Items (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getStockItems($search, $updated_or_created_since, $deleted_since, $active, $out_of_stock, $below_reorder_level, $show_legacy_id, $items_per_page, $page, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling StockItemsApi->getStockItems: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **search** | **string**| Use this to filter by the item code or description. | [optional]
 **updated_or_created_since** | **\DateTime**| Use this to limit the response to Stock Items changed since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Inclusive of the passed timestamp. | [optional]
 **deleted_since** | **\DateTime**| Use this to limit the response to Stock Items deleted since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Not inclusive of the passed timestamp. | [optional]
 **active** | **bool**| Use this to only return active or inactive items | [optional]
 **out_of_stock** | **bool**| Use this to filter by the Stock Items that are out of stock | [optional]
 **below_reorder_level** | **bool**| Use this to filter by the Stock Items that are below the reorder level | [optional]
 **show_legacy_id** | **bool**| Display the legacy_id for the Stock Items. | [optional]
 **items_per_page** | **int**| Returns the given number of Stock Items per request. | [optional] [default to 20]
 **page** | **int**| Go to specific page of Stock Items | [optional] [default to 1]
 **attributes** | **string**| Specify the attributes that you want to expose for the Stock Items (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\PagingStockItem**](../Model/PagingStockItem.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getStockItemsKey()`

```php
getStockItemsKey($key, $show_legacy_id, $attributes): \SageOne\Model\StockItem
```

Returns a Stock Item

Returns a Stock Item

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\StockItemsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Stock Item Key.
$show_legacy_id = True; // bool | Display the legacy_id for the Stock Item.
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Stock Item (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getStockItemsKey($key, $show_legacy_id, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling StockItemsApi->getStockItemsKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Stock Item Key. |
 **show_legacy_id** | **bool**| Display the legacy_id for the Stock Item. | [optional]
 **attributes** | **string**| Specify the attributes that you want to expose for the Stock Item (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\StockItem**](../Model/StockItem.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `postStockItems()`

```php
postStockItems($stock_items): \SageOne\Model\StockItem
```

Creates a Stock Item

Creates a Stock Item

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\StockItemsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$stock_items = new \SageOne\Model\PostStockItems(); // \SageOne\Model\PostStockItems

try {
    $result = $apiInstance->postStockItems($stock_items);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling StockItemsApi->postStockItems: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **stock_items** | [**\SageOne\Model\PostStockItems**](../Model/PostStockItems.md)|  |

### Return type

[**\SageOne\Model\StockItem**](../Model/StockItem.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `putStockItemsKey()`

```php
putStockItemsKey($key, $stock_items): \SageOne\Model\StockItem
```

Updates a Stock Item

Updates a Stock Item

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\StockItemsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Stock Item Key.
$stock_items = new \SageOne\Model\PutStockItems(); // \SageOne\Model\PutStockItems

try {
    $result = $apiInstance->putStockItemsKey($key, $stock_items);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling StockItemsApi->putStockItemsKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Stock Item Key. |
 **stock_items** | [**\SageOne\Model\PutStockItems**](../Model/PutStockItems.md)|  |

### Return type

[**\SageOne\Model\StockItem**](../Model/StockItem.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
