# SageOne\ServicesApi

All URIs are relative to https://api.accounting.sage.com/v3.1.

Method | HTTP request | Description
------------- | ------------- | -------------
[**deleteServicesKey()**](ServicesApi.md#deleteServicesKey) | **DELETE** /services/{key} | Deletes a Service
[**getServices()**](ServicesApi.md#getServices) | **GET** /services | Returns all Services
[**getServicesKey()**](ServicesApi.md#getServicesKey) | **GET** /services/{key} | Returns a Service
[**postServices()**](ServicesApi.md#postServices) | **POST** /services | Creates a Service
[**putServicesKey()**](ServicesApi.md#putServicesKey) | **PUT** /services/{key} | Updates a Service


## `deleteServicesKey()`

```php
deleteServicesKey($key)
```

Deletes a Service

Deletes a Service

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\ServicesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Service Key.

try {
    $apiInstance->deleteServicesKey($key);
} catch (Exception $e) {
    echo 'Exception when calling ServicesApi->deleteServicesKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Service Key. |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getServices()`

```php
getServices($search, $updated_or_created_since, $deleted_since, $active, $show_legacy_id, $items_per_page, $page, $attributes): \SageOne\Model\Service[]
```

Returns all Services

Returns all Services

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\ServicesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$search = 'search_example'; // string | Use this to filter by the item code or description.
$updated_or_created_since = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | Use this to limit the response to Services changed since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Inclusive of the passed timestamp.
$deleted_since = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | Use this to limit the response to Services deleted since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Not inclusive of the passed timestamp.
$active = True; // bool | Use this to only return active or inactive items
$show_legacy_id = True; // bool | Display the legacy_id for the Services.
$items_per_page = 20; // int | Returns the given number of Services per request.
$page = 1; // int | Go to specific page of Services
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Services (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getServices($search, $updated_or_created_since, $deleted_since, $active, $show_legacy_id, $items_per_page, $page, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ServicesApi->getServices: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **search** | **string**| Use this to filter by the item code or description. | [optional]
 **updated_or_created_since** | **\DateTime**| Use this to limit the response to Services changed since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Inclusive of the passed timestamp. | [optional]
 **deleted_since** | **\DateTime**| Use this to limit the response to Services deleted since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Not inclusive of the passed timestamp. | [optional]
 **active** | **bool**| Use this to only return active or inactive items | [optional]
 **show_legacy_id** | **bool**| Display the legacy_id for the Services. | [optional]
 **items_per_page** | **int**| Returns the given number of Services per request. | [optional] [default to 20]
 **page** | **int**| Go to specific page of Services | [optional] [default to 1]
 **attributes** | **string**| Specify the attributes that you want to expose for the Services (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\Service[]**](../Model/Service.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getServicesKey()`

```php
getServicesKey($key, $show_legacy_id, $attributes): \SageOne\Model\Service
```

Returns a Service

Returns a Service

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\ServicesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Service Key.
$show_legacy_id = True; // bool | Display the legacy_id for the Service.
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Service (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getServicesKey($key, $show_legacy_id, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ServicesApi->getServicesKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Service Key. |
 **show_legacy_id** | **bool**| Display the legacy_id for the Service. | [optional]
 **attributes** | **string**| Specify the attributes that you want to expose for the Service (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\Service**](../Model/Service.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `postServices()`

```php
postServices($services): \SageOne\Model\Service
```

Creates a Service

Creates a Service

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\ServicesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$services = new \SageOne\Model\PostServices(); // \SageOne\Model\PostServices

try {
    $result = $apiInstance->postServices($services);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ServicesApi->postServices: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **services** | [**\SageOne\Model\PostServices**](../Model/PostServices.md)|  |

### Return type

[**\SageOne\Model\Service**](../Model/Service.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `putServicesKey()`

```php
putServicesKey($key, $services): \SageOne\Model\Service
```

Updates a Service

Updates a Service

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\ServicesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Service Key.
$services = new \SageOne\Model\PutServices(); // \SageOne\Model\PutServices

try {
    $result = $apiInstance->putServicesKey($key, $services);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ServicesApi->putServicesKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Service Key. |
 **services** | [**\SageOne\Model\PutServices**](../Model/PutServices.md)|  |

### Return type

[**\SageOne\Model\Service**](../Model/Service.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
