# SageOne\ServiceRateTypesApi

All URIs are relative to https://api.accounting.sage.com/v3.1.

Method | HTTP request | Description
------------- | ------------- | -------------
[**deleteServiceRateTypesKey()**](ServiceRateTypesApi.md#deleteServiceRateTypesKey) | **DELETE** /service_rate_types/{key} | Deletes a Service Rate Type
[**getServiceRateTypes()**](ServiceRateTypesApi.md#getServiceRateTypes) | **GET** /service_rate_types | Returns all Service Rate Types
[**getServiceRateTypesKey()**](ServiceRateTypesApi.md#getServiceRateTypesKey) | **GET** /service_rate_types/{key} | Returns a Service Rate Type
[**postServiceRateTypes()**](ServiceRateTypesApi.md#postServiceRateTypes) | **POST** /service_rate_types | Creates a Service Rate Type
[**putServiceRateTypesKey()**](ServiceRateTypesApi.md#putServiceRateTypesKey) | **PUT** /service_rate_types/{key} | Updates a Service Rate Type


## `deleteServiceRateTypesKey()`

```php
deleteServiceRateTypesKey($key)
```

Deletes a Service Rate Type

Deletes a Service Rate Type

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\ServiceRateTypesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Service Rate Type Key.

try {
    $apiInstance->deleteServiceRateTypesKey($key);
} catch (Exception $e) {
    echo 'Exception when calling ServiceRateTypesApi->deleteServiceRateTypesKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Service Rate Type Key. |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getServiceRateTypes()`

```php
getServiceRateTypes($updated_or_created_since, $active, $show_legacy_id, $items_per_page, $page, $attributes): \SageOne\Model\ServiceRateType[]
```

Returns all Service Rate Types

Returns all Service Rate Types

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\ServiceRateTypesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$updated_or_created_since = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | Use this to limit the response to Service Rates changed since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Inclusive of the passed timestamp.
$active = True; // bool | Use this to only return active or inactive items
$show_legacy_id = True; // bool | Display the legacy_id for the Service Rates.
$items_per_page = 20; // int | Returns the given number of Service Rates per request.
$page = 1; // int | Go to specific page of Service Rates
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Service Rates (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getServiceRateTypes($updated_or_created_since, $active, $show_legacy_id, $items_per_page, $page, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ServiceRateTypesApi->getServiceRateTypes: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **updated_or_created_since** | **\DateTime**| Use this to limit the response to Service Rates changed since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Inclusive of the passed timestamp. | [optional]
 **active** | **bool**| Use this to only return active or inactive items | [optional]
 **show_legacy_id** | **bool**| Display the legacy_id for the Service Rates. | [optional]
 **items_per_page** | **int**| Returns the given number of Service Rates per request. | [optional] [default to 20]
 **page** | **int**| Go to specific page of Service Rates | [optional] [default to 1]
 **attributes** | **string**| Specify the attributes that you want to expose for the Service Rates (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\ServiceRateType[]**](../Model/ServiceRateType.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getServiceRateTypesKey()`

```php
getServiceRateTypesKey($key, $show_legacy_id, $attributes): \SageOne\Model\ServiceRateType
```

Returns a Service Rate Type

Returns a Service Rate Type

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\ServiceRateTypesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Service Rate Type Key.
$show_legacy_id = True; // bool | Display the legacy_id for the Service Rate.
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Service Rate (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getServiceRateTypesKey($key, $show_legacy_id, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ServiceRateTypesApi->getServiceRateTypesKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Service Rate Type Key. |
 **show_legacy_id** | **bool**| Display the legacy_id for the Service Rate. | [optional]
 **attributes** | **string**| Specify the attributes that you want to expose for the Service Rate (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\ServiceRateType**](../Model/ServiceRateType.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `postServiceRateTypes()`

```php
postServiceRateTypes($service_rate_types): \SageOne\Model\ServiceRateType
```

Creates a Service Rate Type

Creates a Service Rate Type

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\ServiceRateTypesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$service_rate_types = new \SageOne\Model\PostServiceRateTypes(); // \SageOne\Model\PostServiceRateTypes

try {
    $result = $apiInstance->postServiceRateTypes($service_rate_types);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ServiceRateTypesApi->postServiceRateTypes: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **service_rate_types** | [**\SageOne\Model\PostServiceRateTypes**](../Model/PostServiceRateTypes.md)|  |

### Return type

[**\SageOne\Model\ServiceRateType**](../Model/ServiceRateType.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `putServiceRateTypesKey()`

```php
putServiceRateTypesKey($key, $service_rate_types): \SageOne\Model\ServiceRateType
```

Updates a Service Rate Type

Updates a Service Rate Type

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\ServiceRateTypesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Service Rate Type Key.
$service_rate_types = new \SageOne\Model\PutServiceRateTypes(); // \SageOne\Model\PutServiceRateTypes

try {
    $result = $apiInstance->putServiceRateTypesKey($key, $service_rate_types);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ServiceRateTypesApi->putServiceRateTypesKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Service Rate Type Key. |
 **service_rate_types** | [**\SageOne\Model\PutServiceRateTypes**](../Model/PutServiceRateTypes.md)|  |

### Return type

[**\SageOne\Model\ServiceRateType**](../Model/ServiceRateType.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
