# SageOne\SalesQuotesApi

All URIs are relative to https://api.accounting.sage.com/v3.1.

Method | HTTP request | Description
------------- | ------------- | -------------
[**deleteSalesQuotesKey()**](SalesQuotesApi.md#deleteSalesQuotesKey) | **DELETE** /sales_quotes/{key} | Deletes a Sales Quote
[**getSalesQuotes()**](SalesQuotesApi.md#getSalesQuotes) | **GET** /sales_quotes | Returns all Sales Quotes
[**getSalesQuotesKey()**](SalesQuotesApi.md#getSalesQuotesKey) | **GET** /sales_quotes/{key} | Returns a Sales Quote
[**postSalesQuotes()**](SalesQuotesApi.md#postSalesQuotes) | **POST** /sales_quotes | Creates a Sales Quote
[**putSalesQuotesKey()**](SalesQuotesApi.md#putSalesQuotesKey) | **PUT** /sales_quotes/{key} | Updates a Sales Quote


## `deleteSalesQuotesKey()`

```php
deleteSalesQuotesKey($key)
```

Deletes a Sales Quote

Deletes a Sales Quote

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\SalesQuotesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Sales Quote Key.

try {
    $apiInstance->deleteSalesQuotesKey($key);
} catch (Exception $e) {
    echo 'Exception when calling SalesQuotesApi->deleteSalesQuotesKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Sales Quote Key. |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getSalesQuotes()`

```php
getSalesQuotes($contact_id, $search, $status_id, $from_date, $to_date, $updated_or_created_since, $show_legacy_id, $items_per_page, $page, $attributes): \SageOne\Model\SalesQuote[]
```

Returns all Sales Quotes

Returns all Sales Quotes

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\SalesQuotesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$contact_id = 'contact_id_example'; // string | Use this to filter by contact id
$search = 'search_example'; // string | Use this to filter by the quote reference or contact name.
$status_id = 'status_id_example'; // string | Use this to filter by status id
$from_date = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | Use this to filter by Sales Quotes dates
$to_date = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | Use this to filter by Sales Quotes dates
$updated_or_created_since = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | Use this to limit the response to Sales Quotes changed since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Inclusive of the passed timestamp.
$show_legacy_id = True; // bool | Display the legacy_id for the Sales Quotes.
$items_per_page = 20; // int | Returns the given number of Sales Quotes per request.
$page = 1; // int | Go to specific page of Sales Quotes
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Sales Quotes (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getSalesQuotes($contact_id, $search, $status_id, $from_date, $to_date, $updated_or_created_since, $show_legacy_id, $items_per_page, $page, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SalesQuotesApi->getSalesQuotes: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **contact_id** | **string**| Use this to filter by contact id | [optional]
 **search** | **string**| Use this to filter by the quote reference or contact name. | [optional]
 **status_id** | **string**| Use this to filter by status id | [optional]
 **from_date** | **\DateTime**| Use this to filter by Sales Quotes dates | [optional]
 **to_date** | **\DateTime**| Use this to filter by Sales Quotes dates | [optional]
 **updated_or_created_since** | **\DateTime**| Use this to limit the response to Sales Quotes changed since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Inclusive of the passed timestamp. | [optional]
 **show_legacy_id** | **bool**| Display the legacy_id for the Sales Quotes. | [optional]
 **items_per_page** | **int**| Returns the given number of Sales Quotes per request. | [optional] [default to 20]
 **page** | **int**| Go to specific page of Sales Quotes | [optional] [default to 1]
 **attributes** | **string**| Specify the attributes that you want to expose for the Sales Quotes (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\SalesQuote[]**](../Model/SalesQuote.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getSalesQuotesKey()`

```php
getSalesQuotesKey($key, $nested_attributes, $show_legacy_id, $attributes): \SageOne\Model\SalesQuote
```

Returns a Sales Quote

Returns a Sales Quote

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\SalesQuotesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Sales Quote Key.
$nested_attributes = 'nested_attributes_example'; // string | Specify the attributes that you want to expose for nested entities of the Sales Quote (expose all nested attributes with 'all'). These are in addition to the base attributes (name, path)
$show_legacy_id = True; // bool | Display the legacy_id for the Sales Quote.
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Sales Quote (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getSalesQuotesKey($key, $nested_attributes, $show_legacy_id, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SalesQuotesApi->getSalesQuotesKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Sales Quote Key. |
 **nested_attributes** | **string**| Specify the attributes that you want to expose for nested entities of the Sales Quote (expose all nested attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]
 **show_legacy_id** | **bool**| Display the legacy_id for the Sales Quote. | [optional]
 **attributes** | **string**| Specify the attributes that you want to expose for the Sales Quote (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\SalesQuote**](../Model/SalesQuote.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `postSalesQuotes()`

```php
postSalesQuotes($sales_quotes): \SageOne\Model\SalesQuote
```

Creates a Sales Quote

Creates a Sales Quote

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\SalesQuotesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$sales_quotes = new \SageOne\Model\PostSalesQuotes(); // \SageOne\Model\PostSalesQuotes

try {
    $result = $apiInstance->postSalesQuotes($sales_quotes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SalesQuotesApi->postSalesQuotes: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **sales_quotes** | [**\SageOne\Model\PostSalesQuotes**](../Model/PostSalesQuotes.md)|  |

### Return type

[**\SageOne\Model\SalesQuote**](../Model/SalesQuote.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `putSalesQuotesKey()`

```php
putSalesQuotesKey($key, $sales_quotes): \SageOne\Model\SalesQuote
```

Updates a Sales Quote

Updates a Sales Quote

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\SalesQuotesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Sales Quote Key.
$sales_quotes = new \SageOne\Model\PutSalesQuotes(); // \SageOne\Model\PutSalesQuotes

try {
    $result = $apiInstance->putSalesQuotesKey($key, $sales_quotes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SalesQuotesApi->putSalesQuotesKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Sales Quote Key. |
 **sales_quotes** | [**\SageOne\Model\PutSalesQuotes**](../Model/PutSalesQuotes.md)|  |

### Return type

[**\SageOne\Model\SalesQuote**](../Model/SalesQuote.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
