# SageOne\SalesQuickEntriesApi

All URIs are relative to https://api.accounting.sage.com/v3.1.

Method | HTTP request | Description
------------- | ------------- | -------------
[**deleteSalesQuickEntriesKey()**](SalesQuickEntriesApi.md#deleteSalesQuickEntriesKey) | **DELETE** /sales_quick_entries/{key} | Deletes a Sales Quick Entry
[**getSalesQuickEntries()**](SalesQuickEntriesApi.md#getSalesQuickEntries) | **GET** /sales_quick_entries | Returns all Sales Quick Entries
[**getSalesQuickEntriesKey()**](SalesQuickEntriesApi.md#getSalesQuickEntriesKey) | **GET** /sales_quick_entries/{key} | Returns a Sales Quick Entry
[**postSalesQuickEntries()**](SalesQuickEntriesApi.md#postSalesQuickEntries) | **POST** /sales_quick_entries | Creates a Sales Quick Entry
[**putSalesQuickEntriesKey()**](SalesQuickEntriesApi.md#putSalesQuickEntriesKey) | **PUT** /sales_quick_entries/{key} | Updates a Sales Quick Entry


## `deleteSalesQuickEntriesKey()`

```php
deleteSalesQuickEntriesKey($key)
```

Deletes a Sales Quick Entry

Deletes a Sales Quick Entry

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\SalesQuickEntriesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Sales Quick Entry Key.

try {
    $apiInstance->deleteSalesQuickEntriesKey($key);
} catch (Exception $e) {
    echo 'Exception when calling SalesQuickEntriesApi->deleteSalesQuickEntriesKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Sales Quick Entry Key. |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getSalesQuickEntries()`

```php
getSalesQuickEntries($contact_id, $search, $status_id, $from_date, $to_date, $updated_or_created_since, $deleted_since, $show_payments_allocations, $show_legacy_id, $items_per_page, $page, $attributes): \SageOne\Model\QuickEntry[]
```

Returns all Sales Quick Entries

Returns all Sales Quick Entries

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\SalesQuickEntriesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$contact_id = 'contact_id_example'; // string | Use this to filter by contact id
$search = 'search_example'; // string | Use this to filter by the quick entry reference or contact name.
$status_id = 'status_id_example'; // string | Use this to filter by status id
$from_date = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | Use this to filter by Sales Batch Entries dates
$to_date = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | Use this to filter by Sales Batch Entries dates
$updated_or_created_since = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | Use this to limit the response to Sales Batch Entries changed since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Inclusive of the passed timestamp.
$deleted_since = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | Use this to limit the response to Sales Batch Entries deleted since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Not inclusive of the passed timestamp.
$show_payments_allocations = True; // bool | Use this to show the artefact's payments and allocations
$show_legacy_id = True; // bool | Display the legacy_id for the Sales Batch Entries.
$items_per_page = 20; // int | Returns the given number of Sales Batch Entries per request.
$page = 1; // int | Go to specific page of Sales Batch Entries
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Sales Batch Entries (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getSalesQuickEntries($contact_id, $search, $status_id, $from_date, $to_date, $updated_or_created_since, $deleted_since, $show_payments_allocations, $show_legacy_id, $items_per_page, $page, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SalesQuickEntriesApi->getSalesQuickEntries: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **contact_id** | **string**| Use this to filter by contact id | [optional]
 **search** | **string**| Use this to filter by the quick entry reference or contact name. | [optional]
 **status_id** | **string**| Use this to filter by status id | [optional]
 **from_date** | **\DateTime**| Use this to filter by Sales Batch Entries dates | [optional]
 **to_date** | **\DateTime**| Use this to filter by Sales Batch Entries dates | [optional]
 **updated_or_created_since** | **\DateTime**| Use this to limit the response to Sales Batch Entries changed since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Inclusive of the passed timestamp. | [optional]
 **deleted_since** | **\DateTime**| Use this to limit the response to Sales Batch Entries deleted since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Not inclusive of the passed timestamp. | [optional]
 **show_payments_allocations** | **bool**| Use this to show the artefact&#39;s payments and allocations | [optional]
 **show_legacy_id** | **bool**| Display the legacy_id for the Sales Batch Entries. | [optional]
 **items_per_page** | **int**| Returns the given number of Sales Batch Entries per request. | [optional] [default to 20]
 **page** | **int**| Go to specific page of Sales Batch Entries | [optional] [default to 1]
 **attributes** | **string**| Specify the attributes that you want to expose for the Sales Batch Entries (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\QuickEntry[]**](../Model/QuickEntry.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getSalesQuickEntriesKey()`

```php
getSalesQuickEntriesKey($key, $show_payments_allocations, $nested_attributes, $show_legacy_id, $attributes): \SageOne\Model\QuickEntry
```

Returns a Sales Quick Entry

Returns a Sales Quick Entry

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\SalesQuickEntriesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Sales Quick Entry Key.
$show_payments_allocations = True; // bool | Use this to show the artefact's payments and allocations
$nested_attributes = 'nested_attributes_example'; // string | Specify the attributes that you want to expose for nested entities of the Sales Batch Entry (expose all nested attributes with 'all'). These are in addition to the base attributes (name, path)
$show_legacy_id = True; // bool | Display the legacy_id for the Sales Batch Entry.
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Sales Batch Entry (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getSalesQuickEntriesKey($key, $show_payments_allocations, $nested_attributes, $show_legacy_id, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SalesQuickEntriesApi->getSalesQuickEntriesKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Sales Quick Entry Key. |
 **show_payments_allocations** | **bool**| Use this to show the artefact&#39;s payments and allocations | [optional]
 **nested_attributes** | **string**| Specify the attributes that you want to expose for nested entities of the Sales Batch Entry (expose all nested attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]
 **show_legacy_id** | **bool**| Display the legacy_id for the Sales Batch Entry. | [optional]
 **attributes** | **string**| Specify the attributes that you want to expose for the Sales Batch Entry (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\QuickEntry**](../Model/QuickEntry.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `postSalesQuickEntries()`

```php
postSalesQuickEntries($sales_quick_entries): \SageOne\Model\QuickEntry
```

Creates a Sales Quick Entry

Creates a Sales Quick Entry

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\SalesQuickEntriesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$sales_quick_entries = new \SageOne\Model\PostSalesQuickEntries(); // \SageOne\Model\PostSalesQuickEntries

try {
    $result = $apiInstance->postSalesQuickEntries($sales_quick_entries);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SalesQuickEntriesApi->postSalesQuickEntries: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **sales_quick_entries** | [**\SageOne\Model\PostSalesQuickEntries**](../Model/PostSalesQuickEntries.md)|  |

### Return type

[**\SageOne\Model\QuickEntry**](../Model/QuickEntry.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `putSalesQuickEntriesKey()`

```php
putSalesQuickEntriesKey($key, $sales_quick_entries): \SageOne\Model\QuickEntry
```

Updates a Sales Quick Entry

Updates a Sales Quick Entry

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\SalesQuickEntriesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Sales Quick Entry Key.
$sales_quick_entries = new \SageOne\Model\PutSalesQuickEntries(); // \SageOne\Model\PutSalesQuickEntries

try {
    $result = $apiInstance->putSalesQuickEntriesKey($key, $sales_quick_entries);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SalesQuickEntriesApi->putSalesQuickEntriesKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Sales Quick Entry Key. |
 **sales_quick_entries** | [**\SageOne\Model\PutSalesQuickEntries**](../Model/PutSalesQuickEntries.md)|  |

### Return type

[**\SageOne\Model\QuickEntry**](../Model/QuickEntry.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
