# SageOne\SalesInvoicesApi

All URIs are relative to https://api.accounting.sage.com/v3.1.

Method | HTTP request | Description
------------- | ------------- | -------------
[**deleteSalesInvoicesKey()**](SalesInvoicesApi.md#deleteSalesInvoicesKey) | **DELETE** /sales_invoices/{key} | Voids a Sales Invoice
[**getSalesInvoices()**](SalesInvoicesApi.md#getSalesInvoices) | **GET** /sales_invoices | Returns all Sales Invoices
[**getSalesInvoicesKey()**](SalesInvoicesApi.md#getSalesInvoicesKey) | **GET** /sales_invoices/{key} | Returns a Sales Invoice
[**postSalesInvoices()**](SalesInvoicesApi.md#postSalesInvoices) | **POST** /sales_invoices | Creates a Sales Invoice
[**postSalesInvoicesKeyRelease()**](SalesInvoicesApi.md#postSalesInvoicesKeyRelease) | **POST** /sales_invoices/{key}/release | Releases a Sales Invoice
[**putSalesInvoicesKey()**](SalesInvoicesApi.md#putSalesInvoicesKey) | **PUT** /sales_invoices/{key} | Updates a Sales Invoice


## `deleteSalesInvoicesKey()`

```php
deleteSalesInvoicesKey($key, $void_reason): \SageOne\Model\SalesInvoice
```

Voids a Sales Invoice

Voids a Sales Invoice

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\SalesInvoicesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Sales Invoice Key.
$void_reason = 'void_reason_example'; // string | The reason the Sales Invoice is being voided (required unless status is DRAFT).

try {
    $result = $apiInstance->deleteSalesInvoicesKey($key, $void_reason);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SalesInvoicesApi->deleteSalesInvoicesKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Sales Invoice Key. |
 **void_reason** | **string**| The reason the Sales Invoice is being voided (required unless status is DRAFT). | [optional]

### Return type

[**\SageOne\Model\SalesInvoice**](../Model/SalesInvoice.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getSalesInvoices()`

```php
getSalesInvoices($show_payments_allocations, $search, $contact_id, $status_id, $from_date, $to_date, $updated_or_created_since, $deleted_since, $show_legacy_id, $items_per_page, $page, $attributes): \SageOne\Model\PagingSalesInvoice
```

Returns all Sales Invoices

Returns all Sales Invoices

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\SalesInvoicesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$show_payments_allocations = True; // bool | Use this to show the artefact's payments and allocations
$search = 'search_example'; // string | Use this to filter by the invoice reference or contact name.
$contact_id = 'contact_id_example'; // string | Use this to filter by contact id
$status_id = 'status_id_example'; // string | Use this to filter by status id
$from_date = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | Use this to filter by Sales Invoices dates
$to_date = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | Use this to filter by Sales Invoices dates
$updated_or_created_since = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | Use this to limit the response to Sales Invoices changed since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Inclusive of the passed timestamp.
$deleted_since = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | Use this to limit the response to Sales Invoices deleted since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Not inclusive of the passed timestamp.
$show_legacy_id = True; // bool | Display the legacy_id for the Sales Invoices.
$items_per_page = 20; // int | Returns the given number of Sales Invoices per request.
$page = 1; // int | Go to specific page of Sales Invoices
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Sales Invoices (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getSalesInvoices($show_payments_allocations, $search, $contact_id, $status_id, $from_date, $to_date, $updated_or_created_since, $deleted_since, $show_legacy_id, $items_per_page, $page, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SalesInvoicesApi->getSalesInvoices: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **show_payments_allocations** | **bool**| Use this to show the artefact&#39;s payments and allocations | [optional]
 **search** | **string**| Use this to filter by the invoice reference or contact name. | [optional]
 **contact_id** | **string**| Use this to filter by contact id | [optional]
 **status_id** | **string**| Use this to filter by status id | [optional]
 **from_date** | **\DateTime**| Use this to filter by Sales Invoices dates | [optional]
 **to_date** | **\DateTime**| Use this to filter by Sales Invoices dates | [optional]
 **updated_or_created_since** | **\DateTime**| Use this to limit the response to Sales Invoices changed since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Inclusive of the passed timestamp. | [optional]
 **deleted_since** | **\DateTime**| Use this to limit the response to Sales Invoices deleted since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Not inclusive of the passed timestamp. | [optional]
 **show_legacy_id** | **bool**| Display the legacy_id for the Sales Invoices. | [optional]
 **items_per_page** | **int**| Returns the given number of Sales Invoices per request. | [optional] [default to 20]
 **page** | **int**| Go to specific page of Sales Invoices | [optional] [default to 1]
 **attributes** | **string**| Specify the attributes that you want to expose for the Sales Invoices (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\PagingSalesInvoice**](../Model/PagingSalesInvoice.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getSalesInvoicesKey()`

```php
getSalesInvoicesKey($key, $show_payments_allocations, $show_corrections, $nested_attributes, $mark_as_sent, $show_legacy_id, $attributes): \SageOne\Model\SalesInvoice
```

Returns a Sales Invoice

Returns a Sales Invoice

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\SalesInvoicesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Sales Invoice Key.
$show_payments_allocations = True; // bool | Use this to show the artefact's payments and allocations
$show_corrections = True; // bool | Use this to show the artefact's associated corrections
$nested_attributes = 'nested_attributes_example'; // string | Specify the attributes that you want to expose for nested entities of the Sales Invoice (expose all nested attributes with 'all'). These are in addition to the base attributes (name, path)
$mark_as_sent = True; // bool | Use this to mark/not mark the artefact as sent. Defaulted to 'true'.
$show_legacy_id = True; // bool | Display the legacy_id for the Sales Invoice.
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Sales Invoice (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getSalesInvoicesKey($key, $show_payments_allocations, $show_corrections, $nested_attributes, $mark_as_sent, $show_legacy_id, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SalesInvoicesApi->getSalesInvoicesKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Sales Invoice Key. |
 **show_payments_allocations** | **bool**| Use this to show the artefact&#39;s payments and allocations | [optional]
 **show_corrections** | **bool**| Use this to show the artefact&#39;s associated corrections | [optional]
 **nested_attributes** | **string**| Specify the attributes that you want to expose for nested entities of the Sales Invoice (expose all nested attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]
 **mark_as_sent** | **bool**| Use this to mark/not mark the artefact as sent. Defaulted to &#39;true&#39;. | [optional]
 **show_legacy_id** | **bool**| Display the legacy_id for the Sales Invoice. | [optional]
 **attributes** | **string**| Specify the attributes that you want to expose for the Sales Invoice (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\SalesInvoice**](../Model/SalesInvoice.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `postSalesInvoices()`

```php
postSalesInvoices($sales_invoices): \SageOne\Model\SalesInvoice
```

Creates a Sales Invoice

Creates a Sales Invoice

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\SalesInvoicesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$sales_invoices = new \SageOne\Model\PostSalesInvoices(); // \SageOne\Model\PostSalesInvoices

try {
    $result = $apiInstance->postSalesInvoices($sales_invoices);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SalesInvoicesApi->postSalesInvoices: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **sales_invoices** | [**\SageOne\Model\PostSalesInvoices**](../Model/PostSalesInvoices.md)|  |

### Return type

[**\SageOne\Model\SalesInvoice**](../Model/SalesInvoice.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `postSalesInvoicesKeyRelease()`

```php
postSalesInvoicesKeyRelease($key): \SageOne\Model\SalesInvoice
```

Releases a Sales Invoice

Releases a Sales Invoice

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\SalesInvoicesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Sales Invoice Key.

try {
    $result = $apiInstance->postSalesInvoicesKeyRelease($key);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SalesInvoicesApi->postSalesInvoicesKeyRelease: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Sales Invoice Key. |

### Return type

[**\SageOne\Model\SalesInvoice**](../Model/SalesInvoice.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `putSalesInvoicesKey()`

```php
putSalesInvoicesKey($key, $sales_invoices): \SageOne\Model\SalesInvoice
```

Updates a Sales Invoice

Updates a Sales Invoice

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\SalesInvoicesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Sales Invoice Key.
$sales_invoices = new \SageOne\Model\PutSalesInvoices(); // \SageOne\Model\PutSalesInvoices

try {
    $result = $apiInstance->putSalesInvoicesKey($key, $sales_invoices);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SalesInvoicesApi->putSalesInvoicesKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Sales Invoice Key. |
 **sales_invoices** | [**\SageOne\Model\PutSalesInvoices**](../Model/PutSalesInvoices.md)|  |

### Return type

[**\SageOne\Model\SalesInvoice**](../Model/SalesInvoice.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
