# SageOne\SalesEstimatesApi

All URIs are relative to https://api.accounting.sage.com/v3.1.

Method | HTTP request | Description
------------- | ------------- | -------------
[**deleteSalesEstimatesKey()**](SalesEstimatesApi.md#deleteSalesEstimatesKey) | **DELETE** /sales_estimates/{key} | Deletes a Sales Estimate
[**getSalesEstimates()**](SalesEstimatesApi.md#getSalesEstimates) | **GET** /sales_estimates | Returns all Sales Estimates
[**getSalesEstimatesKey()**](SalesEstimatesApi.md#getSalesEstimatesKey) | **GET** /sales_estimates/{key} | Returns a Sales Estimate
[**postSalesEstimates()**](SalesEstimatesApi.md#postSalesEstimates) | **POST** /sales_estimates | Creates a Sales Estimate
[**putSalesEstimatesKey()**](SalesEstimatesApi.md#putSalesEstimatesKey) | **PUT** /sales_estimates/{key} | Updates a Sales Estimate


## `deleteSalesEstimatesKey()`

```php
deleteSalesEstimatesKey($key)
```

Deletes a Sales Estimate

Deletes a Sales Estimate

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\SalesEstimatesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Sales Estimate Key.

try {
    $apiInstance->deleteSalesEstimatesKey($key);
} catch (Exception $e) {
    echo 'Exception when calling SalesEstimatesApi->deleteSalesEstimatesKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Sales Estimate Key. |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getSalesEstimates()`

```php
getSalesEstimates($contact_id, $search, $status_id, $from_date, $to_date, $updated_or_created_since, $show_legacy_id, $items_per_page, $page, $attributes): \SageOne\Model\SalesEstimate[]
```

Returns all Sales Estimates

Returns all Sales Estimates

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\SalesEstimatesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$contact_id = 'contact_id_example'; // string | Use this to filter by contact id
$search = 'search_example'; // string | Use this to filter by the estimate reference or contact name.
$status_id = 'status_id_example'; // string | Use this to filter by status id
$from_date = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | Use this to filter by Sales Estimates dates
$to_date = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | Use this to filter by Sales Estimates dates
$updated_or_created_since = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | Use this to limit the response to Sales Estimates changed since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Inclusive of the passed timestamp.
$show_legacy_id = True; // bool | Display the legacy_id for the Sales Estimates.
$items_per_page = 20; // int | Returns the given number of Sales Estimates per request.
$page = 1; // int | Go to specific page of Sales Estimates
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Sales Estimates (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getSalesEstimates($contact_id, $search, $status_id, $from_date, $to_date, $updated_or_created_since, $show_legacy_id, $items_per_page, $page, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SalesEstimatesApi->getSalesEstimates: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **contact_id** | **string**| Use this to filter by contact id | [optional]
 **search** | **string**| Use this to filter by the estimate reference or contact name. | [optional]
 **status_id** | **string**| Use this to filter by status id | [optional]
 **from_date** | **\DateTime**| Use this to filter by Sales Estimates dates | [optional]
 **to_date** | **\DateTime**| Use this to filter by Sales Estimates dates | [optional]
 **updated_or_created_since** | **\DateTime**| Use this to limit the response to Sales Estimates changed since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Inclusive of the passed timestamp. | [optional]
 **show_legacy_id** | **bool**| Display the legacy_id for the Sales Estimates. | [optional]
 **items_per_page** | **int**| Returns the given number of Sales Estimates per request. | [optional] [default to 20]
 **page** | **int**| Go to specific page of Sales Estimates | [optional] [default to 1]
 **attributes** | **string**| Specify the attributes that you want to expose for the Sales Estimates (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\SalesEstimate[]**](../Model/SalesEstimate.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getSalesEstimatesKey()`

```php
getSalesEstimatesKey($key, $nested_attributes, $show_legacy_id, $attributes): \SageOne\Model\SalesEstimate
```

Returns a Sales Estimate

Returns a Sales Estimate

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\SalesEstimatesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Sales Estimate Key.
$nested_attributes = 'nested_attributes_example'; // string | Specify the attributes that you want to expose for nested entities of the Sales Estimate (expose all nested attributes with 'all'). These are in addition to the base attributes (name, path)
$show_legacy_id = True; // bool | Display the legacy_id for the Sales Estimate.
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Sales Estimate (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getSalesEstimatesKey($key, $nested_attributes, $show_legacy_id, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SalesEstimatesApi->getSalesEstimatesKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Sales Estimate Key. |
 **nested_attributes** | **string**| Specify the attributes that you want to expose for nested entities of the Sales Estimate (expose all nested attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]
 **show_legacy_id** | **bool**| Display the legacy_id for the Sales Estimate. | [optional]
 **attributes** | **string**| Specify the attributes that you want to expose for the Sales Estimate (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\SalesEstimate**](../Model/SalesEstimate.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `postSalesEstimates()`

```php
postSalesEstimates($sales_estimates): \SageOne\Model\SalesEstimate
```

Creates a Sales Estimate

Creates a Sales Estimate

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\SalesEstimatesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$sales_estimates = new \SageOne\Model\PostSalesEstimates(); // \SageOne\Model\PostSalesEstimates

try {
    $result = $apiInstance->postSalesEstimates($sales_estimates);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SalesEstimatesApi->postSalesEstimates: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **sales_estimates** | [**\SageOne\Model\PostSalesEstimates**](../Model/PostSalesEstimates.md)|  |

### Return type

[**\SageOne\Model\SalesEstimate**](../Model/SalesEstimate.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `putSalesEstimatesKey()`

```php
putSalesEstimatesKey($key, $sales_estimates): \SageOne\Model\SalesEstimate
```

Updates a Sales Estimate

Updates a Sales Estimate

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\SalesEstimatesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Sales Estimate Key.
$sales_estimates = new \SageOne\Model\PutSalesEstimates(); // \SageOne\Model\PutSalesEstimates

try {
    $result = $apiInstance->putSalesEstimatesKey($key, $sales_estimates);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SalesEstimatesApi->putSalesEstimatesKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Sales Estimate Key. |
 **sales_estimates** | [**\SageOne\Model\PutSalesEstimates**](../Model/PutSalesEstimates.md)|  |

### Return type

[**\SageOne\Model\SalesEstimate**](../Model/SalesEstimate.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
