# SageOne\SalesCreditNotesApi

All URIs are relative to https://api.accounting.sage.com/v3.1.

Method | HTTP request | Description
------------- | ------------- | -------------
[**deleteSalesCreditNotesKey()**](SalesCreditNotesApi.md#deleteSalesCreditNotesKey) | **DELETE** /sales_credit_notes/{key} | Voids a Sales Credit Note
[**getSalesCreditNotes()**](SalesCreditNotesApi.md#getSalesCreditNotes) | **GET** /sales_credit_notes | Returns all Sales Credit Notes
[**getSalesCreditNotesKey()**](SalesCreditNotesApi.md#getSalesCreditNotesKey) | **GET** /sales_credit_notes/{key} | Returns a Sales Credit Note
[**postSalesCreditNotes()**](SalesCreditNotesApi.md#postSalesCreditNotes) | **POST** /sales_credit_notes | Creates a Sales Credit Note
[**postSalesCreditNotesKeyRelease()**](SalesCreditNotesApi.md#postSalesCreditNotesKeyRelease) | **POST** /sales_credit_notes/{key}/release | Releases a Sales Credit Note
[**putSalesCreditNotesKey()**](SalesCreditNotesApi.md#putSalesCreditNotesKey) | **PUT** /sales_credit_notes/{key} | Updates a Sales Credit Note


## `deleteSalesCreditNotesKey()`

```php
deleteSalesCreditNotesKey($key, $void_reason): \SageOne\Model\SalesCreditNote
```

Voids a Sales Credit Note

Voids a Sales Credit Note

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\SalesCreditNotesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Sales Credit Note Key.
$void_reason = 'void_reason_example'; // string | The reason the Sales Credit Note is being voided (required unless status is DRAFT).

try {
    $result = $apiInstance->deleteSalesCreditNotesKey($key, $void_reason);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SalesCreditNotesApi->deleteSalesCreditNotesKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Sales Credit Note Key. |
 **void_reason** | **string**| The reason the Sales Credit Note is being voided (required unless status is DRAFT). | [optional]

### Return type

[**\SageOne\Model\SalesCreditNote**](../Model/SalesCreditNote.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getSalesCreditNotes()`

```php
getSalesCreditNotes($show_payments_allocations, $search, $contact_id, $status_id, $from_date, $to_date, $updated_or_created_since, $deleted_since, $show_legacy_id, $items_per_page, $page, $attributes): \SageOne\Model\PagingSalesCreditNote
```

Returns all Sales Credit Notes

Returns all Sales Credit Notes

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\SalesCreditNotesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$show_payments_allocations = True; // bool | Use this to show the artefact's payments and allocations
$search = 'search_example'; // string | Use this to filter by the credit note reference or contact name.
$contact_id = 'contact_id_example'; // string | Use this to filter by contact id
$status_id = 'status_id_example'; // string | Use this to filter by status id
$from_date = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | Use this to filter by Sales Credit Notes dates
$to_date = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | Use this to filter by Sales Credit Notes dates
$updated_or_created_since = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | Use this to limit the response to Sales Credit Notes changed since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Inclusive of the passed timestamp.
$deleted_since = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | Use this to limit the response to Sales Credit Notes deleted since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Not inclusive of the passed timestamp.
$show_legacy_id = True; // bool | Display the legacy_id for the Sales Credit Notes.
$items_per_page = 20; // int | Returns the given number of Sales Credit Notes per request.
$page = 1; // int | Go to specific page of Sales Credit Notes
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Sales Credit Notes (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getSalesCreditNotes($show_payments_allocations, $search, $contact_id, $status_id, $from_date, $to_date, $updated_or_created_since, $deleted_since, $show_legacy_id, $items_per_page, $page, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SalesCreditNotesApi->getSalesCreditNotes: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **show_payments_allocations** | **bool**| Use this to show the artefact&#39;s payments and allocations | [optional]
 **search** | **string**| Use this to filter by the credit note reference or contact name. | [optional]
 **contact_id** | **string**| Use this to filter by contact id | [optional]
 **status_id** | **string**| Use this to filter by status id | [optional]
 **from_date** | **\DateTime**| Use this to filter by Sales Credit Notes dates | [optional]
 **to_date** | **\DateTime**| Use this to filter by Sales Credit Notes dates | [optional]
 **updated_or_created_since** | **\DateTime**| Use this to limit the response to Sales Credit Notes changed since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Inclusive of the passed timestamp. | [optional]
 **deleted_since** | **\DateTime**| Use this to limit the response to Sales Credit Notes deleted since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Not inclusive of the passed timestamp. | [optional]
 **show_legacy_id** | **bool**| Display the legacy_id for the Sales Credit Notes. | [optional]
 **items_per_page** | **int**| Returns the given number of Sales Credit Notes per request. | [optional] [default to 20]
 **page** | **int**| Go to specific page of Sales Credit Notes | [optional] [default to 1]
 **attributes** | **string**| Specify the attributes that you want to expose for the Sales Credit Notes (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\PagingSalesCreditNote**](../Model/PagingSalesCreditNote.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getSalesCreditNotesKey()`

```php
getSalesCreditNotesKey($key, $show_payments_allocations, $nested_attributes, $mark_as_sent, $show_legacy_id, $attributes): \SageOne\Model\SalesCreditNote
```

Returns a Sales Credit Note

Returns a Sales Credit Note

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\SalesCreditNotesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Sales Credit Note Key.
$show_payments_allocations = True; // bool | Use this to show the artefact's payments and allocations
$nested_attributes = 'nested_attributes_example'; // string | Specify the attributes that you want to expose for nested entities of the Sales Credit Note (expose all nested attributes with 'all'). These are in addition to the base attributes (name, path)
$mark_as_sent = True; // bool | Use this to mark/not mark the artefact as sent. Defaulted to 'true'.
$show_legacy_id = True; // bool | Display the legacy_id for the Sales Credit Note.
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Sales Credit Note (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getSalesCreditNotesKey($key, $show_payments_allocations, $nested_attributes, $mark_as_sent, $show_legacy_id, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SalesCreditNotesApi->getSalesCreditNotesKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Sales Credit Note Key. |
 **show_payments_allocations** | **bool**| Use this to show the artefact&#39;s payments and allocations | [optional]
 **nested_attributes** | **string**| Specify the attributes that you want to expose for nested entities of the Sales Credit Note (expose all nested attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]
 **mark_as_sent** | **bool**| Use this to mark/not mark the artefact as sent. Defaulted to &#39;true&#39;. | [optional]
 **show_legacy_id** | **bool**| Display the legacy_id for the Sales Credit Note. | [optional]
 **attributes** | **string**| Specify the attributes that you want to expose for the Sales Credit Note (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\SalesCreditNote**](../Model/SalesCreditNote.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `postSalesCreditNotes()`

```php
postSalesCreditNotes($sales_credit_notes): \SageOne\Model\SalesCreditNote
```

Creates a Sales Credit Note

Creates a Sales Credit Note

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\SalesCreditNotesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$sales_credit_notes = new \SageOne\Model\PostSalesCreditNotes(); // \SageOne\Model\PostSalesCreditNotes

try {
    $result = $apiInstance->postSalesCreditNotes($sales_credit_notes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SalesCreditNotesApi->postSalesCreditNotes: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **sales_credit_notes** | [**\SageOne\Model\PostSalesCreditNotes**](../Model/PostSalesCreditNotes.md)|  |

### Return type

[**\SageOne\Model\SalesCreditNote**](../Model/SalesCreditNote.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `postSalesCreditNotesKeyRelease()`

```php
postSalesCreditNotesKeyRelease($key): \SageOne\Model\SalesCreditNote
```

Releases a Sales Credit Note

Releases a Sales Credit Note

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\SalesCreditNotesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Sales Credit Note Key.

try {
    $result = $apiInstance->postSalesCreditNotesKeyRelease($key);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SalesCreditNotesApi->postSalesCreditNotesKeyRelease: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Sales Credit Note Key. |

### Return type

[**\SageOne\Model\SalesCreditNote**](../Model/SalesCreditNote.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `putSalesCreditNotesKey()`

```php
putSalesCreditNotesKey($key, $sales_credit_notes): \SageOne\Model\SalesCreditNote
```

Updates a Sales Credit Note

Updates a Sales Credit Note

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\SalesCreditNotesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Sales Credit Note Key.
$sales_credit_notes = new \SageOne\Model\PutSalesCreditNotes(); // \SageOne\Model\PutSalesCreditNotes

try {
    $result = $apiInstance->putSalesCreditNotesKey($key, $sales_credit_notes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SalesCreditNotesApi->putSalesCreditNotesKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Sales Credit Note Key. |
 **sales_credit_notes** | [**\SageOne\Model\PutSalesCreditNotes**](../Model/PutSalesCreditNotes.md)|  |

### Return type

[**\SageOne\Model\SalesCreditNote**](../Model/SalesCreditNote.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
