# SageOne\SalesCorrectiveInvoicesApi

All URIs are relative to https://api.accounting.sage.com/v3.1.

Method | HTTP request | Description
------------- | ------------- | -------------
[**deleteSalesCorrectiveInvoicesKey()**](SalesCorrectiveInvoicesApi.md#deleteSalesCorrectiveInvoicesKey) | **DELETE** /sales_corrective_invoices/{key} | Voids a Sales Corrective Invoice
[**getSalesCorrectiveInvoices()**](SalesCorrectiveInvoicesApi.md#getSalesCorrectiveInvoices) | **GET** /sales_corrective_invoices | Returns all Sales Corrective Invoices
[**getSalesCorrectiveInvoicesKey()**](SalesCorrectiveInvoicesApi.md#getSalesCorrectiveInvoicesKey) | **GET** /sales_corrective_invoices/{key} | Returns a Sales Corrective Invoice
[**postSalesCorrectiveInvoices()**](SalesCorrectiveInvoicesApi.md#postSalesCorrectiveInvoices) | **POST** /sales_corrective_invoices | Creates a Sales Corrective Invoice
[**putSalesCorrectiveInvoicesKey()**](SalesCorrectiveInvoicesApi.md#putSalesCorrectiveInvoicesKey) | **PUT** /sales_corrective_invoices/{key} | Updates a Sales Corrective Invoice


## `deleteSalesCorrectiveInvoicesKey()`

```php
deleteSalesCorrectiveInvoicesKey($key, $void_reason): \SageOne\Model\SalesCorrectiveInvoice
```

Voids a Sales Corrective Invoice

Voids a Sales Corrective Invoice

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\SalesCorrectiveInvoicesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Sales Corrective Invoice Key.
$void_reason = 'void_reason_example'; // string | The reason the Sales Corrective Invoice is being voided (required unless status is DRAFT).

try {
    $result = $apiInstance->deleteSalesCorrectiveInvoicesKey($key, $void_reason);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SalesCorrectiveInvoicesApi->deleteSalesCorrectiveInvoicesKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Sales Corrective Invoice Key. |
 **void_reason** | **string**| The reason the Sales Corrective Invoice is being voided (required unless status is DRAFT). | [optional]

### Return type

[**\SageOne\Model\SalesCorrectiveInvoice**](../Model/SalesCorrectiveInvoice.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getSalesCorrectiveInvoices()`

```php
getSalesCorrectiveInvoices($show_payments_allocations, $search, $contact_id, $status_id, $from_date, $to_date, $updated_or_created_since, $deleted_since, $show_legacy_id, $items_per_page, $page, $attributes): \SageOne\Model\SalesCorrectiveInvoice[]
```

Returns all Sales Corrective Invoices

Returns all Sales Corrective Invoices

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\SalesCorrectiveInvoicesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$show_payments_allocations = True; // bool | Use this to show the artefact's payments and allocations
$search = 'search_example'; // string | Use this to filter by the invoice reference or contact name.
$contact_id = 'contact_id_example'; // string | Use this to filter by contact id
$status_id = 'status_id_example'; // string | Use this to filter by status id
$from_date = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | Use this to filter by Sales Corrective Invoices dates
$to_date = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | Use this to filter by Sales Corrective Invoices dates
$updated_or_created_since = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | Use this to limit the response to Sales Corrective Invoices changed since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Inclusive of the passed timestamp.
$deleted_since = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | Use this to limit the response to Sales Corrective Invoices deleted since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Not inclusive of the passed timestamp.
$show_legacy_id = True; // bool | Display the legacy_id for the Sales Corrective Invoices.
$items_per_page = 20; // int | Returns the given number of Sales Corrective Invoices per request.
$page = 1; // int | Go to specific page of Sales Corrective Invoices
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Sales Corrective Invoices (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getSalesCorrectiveInvoices($show_payments_allocations, $search, $contact_id, $status_id, $from_date, $to_date, $updated_or_created_since, $deleted_since, $show_legacy_id, $items_per_page, $page, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SalesCorrectiveInvoicesApi->getSalesCorrectiveInvoices: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **show_payments_allocations** | **bool**| Use this to show the artefact&#39;s payments and allocations | [optional]
 **search** | **string**| Use this to filter by the invoice reference or contact name. | [optional]
 **contact_id** | **string**| Use this to filter by contact id | [optional]
 **status_id** | **string**| Use this to filter by status id | [optional]
 **from_date** | **\DateTime**| Use this to filter by Sales Corrective Invoices dates | [optional]
 **to_date** | **\DateTime**| Use this to filter by Sales Corrective Invoices dates | [optional]
 **updated_or_created_since** | **\DateTime**| Use this to limit the response to Sales Corrective Invoices changed since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Inclusive of the passed timestamp. | [optional]
 **deleted_since** | **\DateTime**| Use this to limit the response to Sales Corrective Invoices deleted since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Not inclusive of the passed timestamp. | [optional]
 **show_legacy_id** | **bool**| Display the legacy_id for the Sales Corrective Invoices. | [optional]
 **items_per_page** | **int**| Returns the given number of Sales Corrective Invoices per request. | [optional] [default to 20]
 **page** | **int**| Go to specific page of Sales Corrective Invoices | [optional] [default to 1]
 **attributes** | **string**| Specify the attributes that you want to expose for the Sales Corrective Invoices (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\SalesCorrectiveInvoice[]**](../Model/SalesCorrectiveInvoice.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getSalesCorrectiveInvoicesKey()`

```php
getSalesCorrectiveInvoicesKey($key, $show_payments_allocations, $nested_attributes, $mark_as_sent, $show_legacy_id, $attributes): \SageOne\Model\SalesCorrectiveInvoice
```

Returns a Sales Corrective Invoice

Returns a Sales Corrective Invoice

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\SalesCorrectiveInvoicesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Sales Corrective Invoice Key.
$show_payments_allocations = True; // bool | Use this to show the artefact's payments and allocations
$nested_attributes = 'nested_attributes_example'; // string | Specify the attributes that you want to expose for nested entities of the Sales Corrective Invoice (expose all nested attributes with 'all'). These are in addition to the base attributes (name, path)
$mark_as_sent = True; // bool | Use this to mark/not mark the artefact as sent. Defaulted to 'true'.
$show_legacy_id = True; // bool | Display the legacy_id for the Sales Corrective Invoice.
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Sales Corrective Invoice (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getSalesCorrectiveInvoicesKey($key, $show_payments_allocations, $nested_attributes, $mark_as_sent, $show_legacy_id, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SalesCorrectiveInvoicesApi->getSalesCorrectiveInvoicesKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Sales Corrective Invoice Key. |
 **show_payments_allocations** | **bool**| Use this to show the artefact&#39;s payments and allocations | [optional]
 **nested_attributes** | **string**| Specify the attributes that you want to expose for nested entities of the Sales Corrective Invoice (expose all nested attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]
 **mark_as_sent** | **bool**| Use this to mark/not mark the artefact as sent. Defaulted to &#39;true&#39;. | [optional]
 **show_legacy_id** | **bool**| Display the legacy_id for the Sales Corrective Invoice. | [optional]
 **attributes** | **string**| Specify the attributes that you want to expose for the Sales Corrective Invoice (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\SalesCorrectiveInvoice**](../Model/SalesCorrectiveInvoice.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `postSalesCorrectiveInvoices()`

```php
postSalesCorrectiveInvoices($sales_corrective_invoices): \SageOne\Model\SalesCorrectiveInvoice
```

Creates a Sales Corrective Invoice

Creates a Sales Corrective Invoice

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\SalesCorrectiveInvoicesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$sales_corrective_invoices = new \SageOne\Model\PostSalesCorrectiveInvoices(); // \SageOne\Model\PostSalesCorrectiveInvoices

try {
    $result = $apiInstance->postSalesCorrectiveInvoices($sales_corrective_invoices);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SalesCorrectiveInvoicesApi->postSalesCorrectiveInvoices: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **sales_corrective_invoices** | [**\SageOne\Model\PostSalesCorrectiveInvoices**](../Model/PostSalesCorrectiveInvoices.md)|  |

### Return type

[**\SageOne\Model\SalesCorrectiveInvoice**](../Model/SalesCorrectiveInvoice.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `putSalesCorrectiveInvoicesKey()`

```php
putSalesCorrectiveInvoicesKey($key, $sales_corrective_invoices): \SageOne\Model\SalesCorrectiveInvoice
```

Updates a Sales Corrective Invoice

Updates a Sales Corrective Invoice

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\SalesCorrectiveInvoicesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Sales Corrective Invoice Key.
$sales_corrective_invoices = new \SageOne\Model\PutSalesCorrectiveInvoices(); // \SageOne\Model\PutSalesCorrectiveInvoices

try {
    $result = $apiInstance->putSalesCorrectiveInvoicesKey($key, $sales_corrective_invoices);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SalesCorrectiveInvoicesApi->putSalesCorrectiveInvoicesKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Sales Corrective Invoice Key. |
 **sales_corrective_invoices** | [**\SageOne\Model\PutSalesCorrectiveInvoices**](../Model/PutSalesCorrectiveInvoices.md)|  |

### Return type

[**\SageOne\Model\SalesCorrectiveInvoice**](../Model/SalesCorrectiveInvoice.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
