# SageOne\QuickEntryTypesApi

All URIs are relative to https://api.accounting.sage.com/v3.1.

Method | HTTP request | Description
------------- | ------------- | -------------
[**getQuickEntryTypes()**](QuickEntryTypesApi.md#getQuickEntryTypes) | **GET** /quick_entry_types | Returns all Quick Entry Types
[**getQuickEntryTypesKey()**](QuickEntryTypesApi.md#getQuickEntryTypesKey) | **GET** /quick_entry_types/{key} | Returns a Quick Entry Type


## `getQuickEntryTypes()`

```php
getQuickEntryTypes($show_legacy_id, $items_per_page, $page, $attributes): \SageOne\Model\Base[]
```

Returns all Quick Entry Types

Returns all Quick Entry Types

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\QuickEntryTypesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$show_legacy_id = True; // bool | Display the legacy_id for the Batch Entry Types.
$items_per_page = 20; // int | Returns the given number of Batch Entry Types per request.
$page = 1; // int | Go to specific page of Batch Entry Types
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Batch Entry Types (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getQuickEntryTypes($show_legacy_id, $items_per_page, $page, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling QuickEntryTypesApi->getQuickEntryTypes: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **show_legacy_id** | **bool**| Display the legacy_id for the Batch Entry Types. | [optional]
 **items_per_page** | **int**| Returns the given number of Batch Entry Types per request. | [optional] [default to 20]
 **page** | **int**| Go to specific page of Batch Entry Types | [optional] [default to 1]
 **attributes** | **string**| Specify the attributes that you want to expose for the Batch Entry Types (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\Base[]**](../Model/Base.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getQuickEntryTypesKey()`

```php
getQuickEntryTypesKey($key, $show_legacy_id, $attributes): \SageOne\Model\Base
```

Returns a Quick Entry Type

Returns a Quick Entry Type

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\QuickEntryTypesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Quick Entry Type Key.
$show_legacy_id = True; // bool | Display the legacy_id for the Batch Entry Type.
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Batch Entry Type (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getQuickEntryTypesKey($key, $show_legacy_id, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling QuickEntryTypesApi->getQuickEntryTypesKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Quick Entry Type Key. |
 **show_legacy_id** | **bool**| Display the legacy_id for the Batch Entry Type. | [optional]
 **attributes** | **string**| Specify the attributes that you want to expose for the Batch Entry Type (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\Base**](../Model/Base.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
