# SageOne\PurchaseQuickEntriesApi

All URIs are relative to https://api.accounting.sage.com/v3.1.

Method | HTTP request | Description
------------- | ------------- | -------------
[**deletePurchaseQuickEntriesKey()**](PurchaseQuickEntriesApi.md#deletePurchaseQuickEntriesKey) | **DELETE** /purchase_quick_entries/{key} | Deletes a Purchase Quick Entry
[**getPurchaseQuickEntries()**](PurchaseQuickEntriesApi.md#getPurchaseQuickEntries) | **GET** /purchase_quick_entries | Returns all Purchase Quick Entries
[**getPurchaseQuickEntriesKey()**](PurchaseQuickEntriesApi.md#getPurchaseQuickEntriesKey) | **GET** /purchase_quick_entries/{key} | Returns a Purchase Quick Entry
[**postPurchaseQuickEntries()**](PurchaseQuickEntriesApi.md#postPurchaseQuickEntries) | **POST** /purchase_quick_entries | Creates a Purchase Quick Entry
[**putPurchaseQuickEntriesKey()**](PurchaseQuickEntriesApi.md#putPurchaseQuickEntriesKey) | **PUT** /purchase_quick_entries/{key} | Updates a Purchase Quick Entry


## `deletePurchaseQuickEntriesKey()`

```php
deletePurchaseQuickEntriesKey($key)
```

Deletes a Purchase Quick Entry

Deletes a Purchase Quick Entry

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\PurchaseQuickEntriesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Purchase Quick Entry Key.

try {
    $apiInstance->deletePurchaseQuickEntriesKey($key);
} catch (Exception $e) {
    echo 'Exception when calling PurchaseQuickEntriesApi->deletePurchaseQuickEntriesKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Purchase Quick Entry Key. |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getPurchaseQuickEntries()`

```php
getPurchaseQuickEntries($contact_id, $search, $status_id, $from_date, $to_date, $updated_or_created_since, $deleted_since, $show_payments_allocations, $show_legacy_id, $items_per_page, $page, $attributes): \SageOne\Model\QuickEntry[]
```

Returns all Purchase Quick Entries

Returns all Purchase Quick Entries

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\PurchaseQuickEntriesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$contact_id = 'contact_id_example'; // string | Use this to filter by contact id
$search = 'search_example'; // string | Use this to filter by the quick entry reference or contact name.
$status_id = 'status_id_example'; // string | Use this to filter by status id
$from_date = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | Use this to filter by Purchase Batch Entries dates
$to_date = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | Use this to filter by Purchase Batch Entries dates
$updated_or_created_since = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | Use this to limit the response to Purchase Batch Entries changed since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Inclusive of the passed timestamp.
$deleted_since = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | Use this to limit the response to Purchase Batch Entries deleted since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Not inclusive of the passed timestamp.
$show_payments_allocations = True; // bool | Use this to show the artefact's payments and allocations
$show_legacy_id = True; // bool | Display the legacy_id for the Purchase Batch Entries.
$items_per_page = 20; // int | Returns the given number of Purchase Batch Entries per request.
$page = 1; // int | Go to specific page of Purchase Batch Entries
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Purchase Batch Entries (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getPurchaseQuickEntries($contact_id, $search, $status_id, $from_date, $to_date, $updated_or_created_since, $deleted_since, $show_payments_allocations, $show_legacy_id, $items_per_page, $page, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PurchaseQuickEntriesApi->getPurchaseQuickEntries: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **contact_id** | **string**| Use this to filter by contact id | [optional]
 **search** | **string**| Use this to filter by the quick entry reference or contact name. | [optional]
 **status_id** | **string**| Use this to filter by status id | [optional]
 **from_date** | **\DateTime**| Use this to filter by Purchase Batch Entries dates | [optional]
 **to_date** | **\DateTime**| Use this to filter by Purchase Batch Entries dates | [optional]
 **updated_or_created_since** | **\DateTime**| Use this to limit the response to Purchase Batch Entries changed since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Inclusive of the passed timestamp. | [optional]
 **deleted_since** | **\DateTime**| Use this to limit the response to Purchase Batch Entries deleted since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Not inclusive of the passed timestamp. | [optional]
 **show_payments_allocations** | **bool**| Use this to show the artefact&#39;s payments and allocations | [optional]
 **show_legacy_id** | **bool**| Display the legacy_id for the Purchase Batch Entries. | [optional]
 **items_per_page** | **int**| Returns the given number of Purchase Batch Entries per request. | [optional] [default to 20]
 **page** | **int**| Go to specific page of Purchase Batch Entries | [optional] [default to 1]
 **attributes** | **string**| Specify the attributes that you want to expose for the Purchase Batch Entries (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\QuickEntry[]**](../Model/QuickEntry.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getPurchaseQuickEntriesKey()`

```php
getPurchaseQuickEntriesKey($key, $show_payments_allocations, $nested_attributes, $show_legacy_id, $attributes): \SageOne\Model\QuickEntry
```

Returns a Purchase Quick Entry

Returns a Purchase Quick Entry

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\PurchaseQuickEntriesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Purchase Quick Entry Key.
$show_payments_allocations = True; // bool | Use this to show the artefact's payments and allocations
$nested_attributes = 'nested_attributes_example'; // string | Specify the attributes that you want to expose for nested entities of the Purchase Batch Entry (expose all nested attributes with 'all'). These are in addition to the base attributes (name, path)
$show_legacy_id = True; // bool | Display the legacy_id for the Purchase Batch Entry.
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Purchase Batch Entry (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getPurchaseQuickEntriesKey($key, $show_payments_allocations, $nested_attributes, $show_legacy_id, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PurchaseQuickEntriesApi->getPurchaseQuickEntriesKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Purchase Quick Entry Key. |
 **show_payments_allocations** | **bool**| Use this to show the artefact&#39;s payments and allocations | [optional]
 **nested_attributes** | **string**| Specify the attributes that you want to expose for nested entities of the Purchase Batch Entry (expose all nested attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]
 **show_legacy_id** | **bool**| Display the legacy_id for the Purchase Batch Entry. | [optional]
 **attributes** | **string**| Specify the attributes that you want to expose for the Purchase Batch Entry (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\QuickEntry**](../Model/QuickEntry.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `postPurchaseQuickEntries()`

```php
postPurchaseQuickEntries($purchase_quick_entries): \SageOne\Model\QuickEntry
```

Creates a Purchase Quick Entry

Creates a Purchase Quick Entry

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\PurchaseQuickEntriesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$purchase_quick_entries = new \SageOne\Model\PostPurchaseQuickEntries(); // \SageOne\Model\PostPurchaseQuickEntries

try {
    $result = $apiInstance->postPurchaseQuickEntries($purchase_quick_entries);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PurchaseQuickEntriesApi->postPurchaseQuickEntries: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **purchase_quick_entries** | [**\SageOne\Model\PostPurchaseQuickEntries**](../Model/PostPurchaseQuickEntries.md)|  |

### Return type

[**\SageOne\Model\QuickEntry**](../Model/QuickEntry.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `putPurchaseQuickEntriesKey()`

```php
putPurchaseQuickEntriesKey($key, $purchase_quick_entries): \SageOne\Model\QuickEntry
```

Updates a Purchase Quick Entry

Updates a Purchase Quick Entry

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\PurchaseQuickEntriesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Purchase Quick Entry Key.
$purchase_quick_entries = new \SageOne\Model\PutPurchaseQuickEntries(); // \SageOne\Model\PutPurchaseQuickEntries

try {
    $result = $apiInstance->putPurchaseQuickEntriesKey($key, $purchase_quick_entries);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PurchaseQuickEntriesApi->putPurchaseQuickEntriesKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Purchase Quick Entry Key. |
 **purchase_quick_entries** | [**\SageOne\Model\PutPurchaseQuickEntries**](../Model/PutPurchaseQuickEntries.md)|  |

### Return type

[**\SageOne\Model\QuickEntry**](../Model/QuickEntry.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
