# SageOne\PurchaseInvoicesApi

All URIs are relative to https://api.accounting.sage.com/v3.1.

Method | HTTP request | Description
------------- | ------------- | -------------
[**deletePurchaseInvoicesKey()**](PurchaseInvoicesApi.md#deletePurchaseInvoicesKey) | **DELETE** /purchase_invoices/{key} | Deletes a Purchase Invoice
[**getPurchaseInvoices()**](PurchaseInvoicesApi.md#getPurchaseInvoices) | **GET** /purchase_invoices | Returns all Purchase Invoices
[**getPurchaseInvoicesKey()**](PurchaseInvoicesApi.md#getPurchaseInvoicesKey) | **GET** /purchase_invoices/{key} | Returns a Purchase Invoice
[**postPurchaseInvoices()**](PurchaseInvoicesApi.md#postPurchaseInvoices) | **POST** /purchase_invoices | Creates a Purchase Invoice
[**postPurchaseInvoicesKeyRelease()**](PurchaseInvoicesApi.md#postPurchaseInvoicesKeyRelease) | **POST** /purchase_invoices/{key}/release | Releases a Purchase Invoice
[**putPurchaseInvoicesKey()**](PurchaseInvoicesApi.md#putPurchaseInvoicesKey) | **PUT** /purchase_invoices/{key} | Updates a Purchase Invoice


## `deletePurchaseInvoicesKey()`

```php
deletePurchaseInvoicesKey($key)
```

Deletes a Purchase Invoice

Deletes a Purchase Invoice

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\PurchaseInvoicesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Purchase Invoice Key.

try {
    $apiInstance->deletePurchaseInvoicesKey($key);
} catch (Exception $e) {
    echo 'Exception when calling PurchaseInvoicesApi->deletePurchaseInvoicesKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Purchase Invoice Key. |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getPurchaseInvoices()`

```php
getPurchaseInvoices($show_payments_allocations, $search, $contact_id, $status_id, $from_date, $to_date, $updated_or_created_since, $deleted_since, $show_legacy_id, $items_per_page, $page, $attributes): \SageOne\Model\PurchaseInvoice[]
```

Returns all Purchase Invoices

Returns all Purchase Invoices

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\PurchaseInvoicesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$show_payments_allocations = True; // bool | Use this to show the artefact's payments and allocations
$search = 'search_example'; // string | Use this to filter by the invoice reference or contact name.
$contact_id = 'contact_id_example'; // string | Use this to filter by contact id
$status_id = 'status_id_example'; // string | Use this to filter by status id
$from_date = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | Use this to filter by Purchase Invoices dates
$to_date = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | Use this to filter by Purchase Invoices dates
$updated_or_created_since = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | Use this to limit the response to Purchase Invoices changed since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Inclusive of the passed timestamp.
$deleted_since = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | Use this to limit the response to Purchase Invoices deleted since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Not inclusive of the passed timestamp.
$show_legacy_id = True; // bool | Display the legacy_id for the Purchase Invoices.
$items_per_page = 20; // int | Returns the given number of Purchase Invoices per request.
$page = 1; // int | Go to specific page of Purchase Invoices
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Purchase Invoices (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getPurchaseInvoices($show_payments_allocations, $search, $contact_id, $status_id, $from_date, $to_date, $updated_or_created_since, $deleted_since, $show_legacy_id, $items_per_page, $page, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PurchaseInvoicesApi->getPurchaseInvoices: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **show_payments_allocations** | **bool**| Use this to show the artefact&#39;s payments and allocations | [optional]
 **search** | **string**| Use this to filter by the invoice reference or contact name. | [optional]
 **contact_id** | **string**| Use this to filter by contact id | [optional]
 **status_id** | **string**| Use this to filter by status id | [optional]
 **from_date** | **\DateTime**| Use this to filter by Purchase Invoices dates | [optional]
 **to_date** | **\DateTime**| Use this to filter by Purchase Invoices dates | [optional]
 **updated_or_created_since** | **\DateTime**| Use this to limit the response to Purchase Invoices changed since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Inclusive of the passed timestamp. | [optional]
 **deleted_since** | **\DateTime**| Use this to limit the response to Purchase Invoices deleted since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Not inclusive of the passed timestamp. | [optional]
 **show_legacy_id** | **bool**| Display the legacy_id for the Purchase Invoices. | [optional]
 **items_per_page** | **int**| Returns the given number of Purchase Invoices per request. | [optional] [default to 20]
 **page** | **int**| Go to specific page of Purchase Invoices | [optional] [default to 1]
 **attributes** | **string**| Specify the attributes that you want to expose for the Purchase Invoices (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\PurchaseInvoice[]**](../Model/PurchaseInvoice.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getPurchaseInvoicesKey()`

```php
getPurchaseInvoicesKey($key, $show_payments_allocations, $show_corrections, $nested_attributes, $show_legacy_id, $attributes): \SageOne\Model\PurchaseInvoice
```

Returns a Purchase Invoice

Returns a Purchase Invoice

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\PurchaseInvoicesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Purchase Invoice Key.
$show_payments_allocations = True; // bool | Use this to show the artefact's payments and allocations
$show_corrections = True; // bool | Use this to show the artefact's associated corrections
$nested_attributes = 'nested_attributes_example'; // string | Specify the attributes that you want to expose for nested entities of the Purchase Invoice (expose all nested attributes with 'all'). These are in addition to the base attributes (name, path)
$show_legacy_id = True; // bool | Display the legacy_id for the Purchase Invoice.
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Purchase Invoice (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getPurchaseInvoicesKey($key, $show_payments_allocations, $show_corrections, $nested_attributes, $show_legacy_id, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PurchaseInvoicesApi->getPurchaseInvoicesKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Purchase Invoice Key. |
 **show_payments_allocations** | **bool**| Use this to show the artefact&#39;s payments and allocations | [optional]
 **show_corrections** | **bool**| Use this to show the artefact&#39;s associated corrections | [optional]
 **nested_attributes** | **string**| Specify the attributes that you want to expose for nested entities of the Purchase Invoice (expose all nested attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]
 **show_legacy_id** | **bool**| Display the legacy_id for the Purchase Invoice. | [optional]
 **attributes** | **string**| Specify the attributes that you want to expose for the Purchase Invoice (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\PurchaseInvoice**](../Model/PurchaseInvoice.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `postPurchaseInvoices()`

```php
postPurchaseInvoices($purchase_invoices): \SageOne\Model\PurchaseInvoice
```

Creates a Purchase Invoice

Creates a Purchase Invoice

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\PurchaseInvoicesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$purchase_invoices = new \SageOne\Model\PostPurchaseInvoices(); // \SageOne\Model\PostPurchaseInvoices

try {
    $result = $apiInstance->postPurchaseInvoices($purchase_invoices);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PurchaseInvoicesApi->postPurchaseInvoices: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **purchase_invoices** | [**\SageOne\Model\PostPurchaseInvoices**](../Model/PostPurchaseInvoices.md)|  |

### Return type

[**\SageOne\Model\PurchaseInvoice**](../Model/PurchaseInvoice.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `postPurchaseInvoicesKeyRelease()`

```php
postPurchaseInvoicesKeyRelease($key): \SageOne\Model\PurchaseInvoice
```

Releases a Purchase Invoice

Releases a Purchase Invoice

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\PurchaseInvoicesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Purchase Invoice Key.

try {
    $result = $apiInstance->postPurchaseInvoicesKeyRelease($key);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PurchaseInvoicesApi->postPurchaseInvoicesKeyRelease: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Purchase Invoice Key. |

### Return type

[**\SageOne\Model\PurchaseInvoice**](../Model/PurchaseInvoice.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `putPurchaseInvoicesKey()`

```php
putPurchaseInvoicesKey($key, $purchase_invoices): \SageOne\Model\PurchaseInvoice
```

Updates a Purchase Invoice

Updates a Purchase Invoice

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\PurchaseInvoicesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Purchase Invoice Key.
$purchase_invoices = new \SageOne\Model\PutPurchaseInvoices(); // \SageOne\Model\PutPurchaseInvoices

try {
    $result = $apiInstance->putPurchaseInvoicesKey($key, $purchase_invoices);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PurchaseInvoicesApi->putPurchaseInvoicesKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Purchase Invoice Key. |
 **purchase_invoices** | [**\SageOne\Model\PutPurchaseInvoices**](../Model/PutPurchaseInvoices.md)|  |

### Return type

[**\SageOne\Model\PurchaseInvoice**](../Model/PurchaseInvoice.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
