# SageOne\PurchaseCreditNotesApi

All URIs are relative to https://api.accounting.sage.com/v3.1.

Method | HTTP request | Description
------------- | ------------- | -------------
[**deletePurchaseCreditNotesKey()**](PurchaseCreditNotesApi.md#deletePurchaseCreditNotesKey) | **DELETE** /purchase_credit_notes/{key} | Deletes a Purchase Credit Note
[**getPurchaseCreditNotes()**](PurchaseCreditNotesApi.md#getPurchaseCreditNotes) | **GET** /purchase_credit_notes | Returns all Purchase Credit Notes
[**getPurchaseCreditNotesKey()**](PurchaseCreditNotesApi.md#getPurchaseCreditNotesKey) | **GET** /purchase_credit_notes/{key} | Returns a Purchase Credit Note
[**postPurchaseCreditNotes()**](PurchaseCreditNotesApi.md#postPurchaseCreditNotes) | **POST** /purchase_credit_notes | Creates a Purchase Credit Note
[**postPurchaseCreditNotesKeyRelease()**](PurchaseCreditNotesApi.md#postPurchaseCreditNotesKeyRelease) | **POST** /purchase_credit_notes/{key}/release | Releases a Purchase Credit Note
[**putPurchaseCreditNotesKey()**](PurchaseCreditNotesApi.md#putPurchaseCreditNotesKey) | **PUT** /purchase_credit_notes/{key} | Updates a Purchase Credit Note


## `deletePurchaseCreditNotesKey()`

```php
deletePurchaseCreditNotesKey($key)
```

Deletes a Purchase Credit Note

Deletes a Purchase Credit Note

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\PurchaseCreditNotesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Purchase Credit Note Key.

try {
    $apiInstance->deletePurchaseCreditNotesKey($key);
} catch (Exception $e) {
    echo 'Exception when calling PurchaseCreditNotesApi->deletePurchaseCreditNotesKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Purchase Credit Note Key. |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getPurchaseCreditNotes()`

```php
getPurchaseCreditNotes($show_payments_allocations, $search, $contact_id, $status_id, $from_date, $to_date, $updated_or_created_since, $deleted_since, $show_legacy_id, $items_per_page, $page, $attributes): \SageOne\Model\PurchaseCreditNote[]
```

Returns all Purchase Credit Notes

Returns all Purchase Credit Notes

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\PurchaseCreditNotesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$show_payments_allocations = True; // bool | Use this to show the artefact's payments and allocations
$search = 'search_example'; // string | Use this to filter by the credit note reference or contact name.
$contact_id = 'contact_id_example'; // string | Use this to filter by contact id
$status_id = 'status_id_example'; // string | Use this to filter by status id
$from_date = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | Use this to filter by Purchase Credit Notes dates
$to_date = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | Use this to filter by Purchase Credit Notes dates
$updated_or_created_since = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | Use this to limit the response to Purchase Credit Notes changed since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Inclusive of the passed timestamp.
$deleted_since = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | Use this to limit the response to Purchase Credit Notes deleted since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Not inclusive of the passed timestamp.
$show_legacy_id = True; // bool | Display the legacy_id for the Purchase Credit Notes.
$items_per_page = 20; // int | Returns the given number of Purchase Credit Notes per request.
$page = 1; // int | Go to specific page of Purchase Credit Notes
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Purchase Credit Notes (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getPurchaseCreditNotes($show_payments_allocations, $search, $contact_id, $status_id, $from_date, $to_date, $updated_or_created_since, $deleted_since, $show_legacy_id, $items_per_page, $page, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PurchaseCreditNotesApi->getPurchaseCreditNotes: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **show_payments_allocations** | **bool**| Use this to show the artefact&#39;s payments and allocations | [optional]
 **search** | **string**| Use this to filter by the credit note reference or contact name. | [optional]
 **contact_id** | **string**| Use this to filter by contact id | [optional]
 **status_id** | **string**| Use this to filter by status id | [optional]
 **from_date** | **\DateTime**| Use this to filter by Purchase Credit Notes dates | [optional]
 **to_date** | **\DateTime**| Use this to filter by Purchase Credit Notes dates | [optional]
 **updated_or_created_since** | **\DateTime**| Use this to limit the response to Purchase Credit Notes changed since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Inclusive of the passed timestamp. | [optional]
 **deleted_since** | **\DateTime**| Use this to limit the response to Purchase Credit Notes deleted since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Not inclusive of the passed timestamp. | [optional]
 **show_legacy_id** | **bool**| Display the legacy_id for the Purchase Credit Notes. | [optional]
 **items_per_page** | **int**| Returns the given number of Purchase Credit Notes per request. | [optional] [default to 20]
 **page** | **int**| Go to specific page of Purchase Credit Notes | [optional] [default to 1]
 **attributes** | **string**| Specify the attributes that you want to expose for the Purchase Credit Notes (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\PurchaseCreditNote[]**](../Model/PurchaseCreditNote.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getPurchaseCreditNotesKey()`

```php
getPurchaseCreditNotesKey($key, $show_payments_allocations, $nested_attributes, $show_legacy_id, $attributes): \SageOne\Model\PurchaseCreditNote
```

Returns a Purchase Credit Note

Returns a Purchase Credit Note

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\PurchaseCreditNotesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Purchase Credit Note Key.
$show_payments_allocations = True; // bool | Use this to show the artefact's payments and allocations
$nested_attributes = 'nested_attributes_example'; // string | Specify the attributes that you want to expose for nested entities of the Purchase Credit Note (expose all nested attributes with 'all'). These are in addition to the base attributes (name, path)
$show_legacy_id = True; // bool | Display the legacy_id for the Purchase Credit Note.
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Purchase Credit Note (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getPurchaseCreditNotesKey($key, $show_payments_allocations, $nested_attributes, $show_legacy_id, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PurchaseCreditNotesApi->getPurchaseCreditNotesKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Purchase Credit Note Key. |
 **show_payments_allocations** | **bool**| Use this to show the artefact&#39;s payments and allocations | [optional]
 **nested_attributes** | **string**| Specify the attributes that you want to expose for nested entities of the Purchase Credit Note (expose all nested attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]
 **show_legacy_id** | **bool**| Display the legacy_id for the Purchase Credit Note. | [optional]
 **attributes** | **string**| Specify the attributes that you want to expose for the Purchase Credit Note (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\PurchaseCreditNote**](../Model/PurchaseCreditNote.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `postPurchaseCreditNotes()`

```php
postPurchaseCreditNotes($purchase_credit_notes): \SageOne\Model\PurchaseCreditNote
```

Creates a Purchase Credit Note

Creates a Purchase Credit Note

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\PurchaseCreditNotesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$purchase_credit_notes = new \SageOne\Model\PostPurchaseCreditNotes(); // \SageOne\Model\PostPurchaseCreditNotes

try {
    $result = $apiInstance->postPurchaseCreditNotes($purchase_credit_notes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PurchaseCreditNotesApi->postPurchaseCreditNotes: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **purchase_credit_notes** | [**\SageOne\Model\PostPurchaseCreditNotes**](../Model/PostPurchaseCreditNotes.md)|  |

### Return type

[**\SageOne\Model\PurchaseCreditNote**](../Model/PurchaseCreditNote.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `postPurchaseCreditNotesKeyRelease()`

```php
postPurchaseCreditNotesKeyRelease($key): \SageOne\Model\PurchaseCreditNote
```

Releases a Purchase Credit Note

Releases a Purchase Credit Note

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\PurchaseCreditNotesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Purchase Credit Note Key.

try {
    $result = $apiInstance->postPurchaseCreditNotesKeyRelease($key);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PurchaseCreditNotesApi->postPurchaseCreditNotesKeyRelease: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Purchase Credit Note Key. |

### Return type

[**\SageOne\Model\PurchaseCreditNote**](../Model/PurchaseCreditNote.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `putPurchaseCreditNotesKey()`

```php
putPurchaseCreditNotesKey($key, $purchase_credit_notes): \SageOne\Model\PurchaseCreditNote
```

Updates a Purchase Credit Note

Updates a Purchase Credit Note

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\PurchaseCreditNotesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Purchase Credit Note Key.
$purchase_credit_notes = new \SageOne\Model\PutPurchaseCreditNotes(); // \SageOne\Model\PutPurchaseCreditNotes

try {
    $result = $apiInstance->putPurchaseCreditNotesKey($key, $purchase_credit_notes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PurchaseCreditNotesApi->putPurchaseCreditNotesKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Purchase Credit Note Key. |
 **purchase_credit_notes** | [**\SageOne\Model\PutPurchaseCreditNotes**](../Model/PutPurchaseCreditNotes.md)|  |

### Return type

[**\SageOne\Model\PurchaseCreditNote**](../Model/PurchaseCreditNote.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
