# SageOne\PurchaseCorrectiveInvoicesApi

All URIs are relative to https://api.accounting.sage.com/v3.1.

Method | HTTP request | Description
------------- | ------------- | -------------
[**deletePurchaseCorrectiveInvoicesKey()**](PurchaseCorrectiveInvoicesApi.md#deletePurchaseCorrectiveInvoicesKey) | **DELETE** /purchase_corrective_invoices/{key} | Deletes a Purchase Corrective Invoice
[**getPurchaseCorrectiveInvoices()**](PurchaseCorrectiveInvoicesApi.md#getPurchaseCorrectiveInvoices) | **GET** /purchase_corrective_invoices | Returns all Purchase Corrective Invoices
[**getPurchaseCorrectiveInvoicesKey()**](PurchaseCorrectiveInvoicesApi.md#getPurchaseCorrectiveInvoicesKey) | **GET** /purchase_corrective_invoices/{key} | Returns a Purchase Corrective Invoice
[**postPurchaseCorrectiveInvoices()**](PurchaseCorrectiveInvoicesApi.md#postPurchaseCorrectiveInvoices) | **POST** /purchase_corrective_invoices | Creates a Purchase Corrective Invoice
[**putPurchaseCorrectiveInvoicesKey()**](PurchaseCorrectiveInvoicesApi.md#putPurchaseCorrectiveInvoicesKey) | **PUT** /purchase_corrective_invoices/{key} | Updates a Purchase Corrective Invoice


## `deletePurchaseCorrectiveInvoicesKey()`

```php
deletePurchaseCorrectiveInvoicesKey($key)
```

Deletes a Purchase Corrective Invoice

Deletes a Purchase Corrective Invoice

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\PurchaseCorrectiveInvoicesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Purchase Corrective Invoice Key.

try {
    $apiInstance->deletePurchaseCorrectiveInvoicesKey($key);
} catch (Exception $e) {
    echo 'Exception when calling PurchaseCorrectiveInvoicesApi->deletePurchaseCorrectiveInvoicesKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Purchase Corrective Invoice Key. |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getPurchaseCorrectiveInvoices()`

```php
getPurchaseCorrectiveInvoices($show_payments_allocations, $search, $contact_id, $status_id, $from_date, $to_date, $updated_or_created_since, $deleted_since, $show_legacy_id, $items_per_page, $page, $attributes): \SageOne\Model\PurchaseCorrectiveInvoice[]
```

Returns all Purchase Corrective Invoices

Returns all Purchase Corrective Invoices

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\PurchaseCorrectiveInvoicesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$show_payments_allocations = True; // bool | Use this to show the artefact's payments and allocations
$search = 'search_example'; // string | Use this to filter by the invoice reference or contact name.
$contact_id = 'contact_id_example'; // string | Use this to filter by contact id
$status_id = 'status_id_example'; // string | Use this to filter by status id
$from_date = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | Use this to filter by Purchase Corrective Invoices dates
$to_date = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | Use this to filter by Purchase Corrective Invoices dates
$updated_or_created_since = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | Use this to limit the response to Purchase Corrective Invoices changed since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Inclusive of the passed timestamp.
$deleted_since = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | Use this to limit the response to Purchase Corrective Invoices deleted since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Not inclusive of the passed timestamp.
$show_legacy_id = True; // bool | Display the legacy_id for the Purchase Corrective Invoices.
$items_per_page = 20; // int | Returns the given number of Purchase Corrective Invoices per request.
$page = 1; // int | Go to specific page of Purchase Corrective Invoices
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Purchase Corrective Invoices (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getPurchaseCorrectiveInvoices($show_payments_allocations, $search, $contact_id, $status_id, $from_date, $to_date, $updated_or_created_since, $deleted_since, $show_legacy_id, $items_per_page, $page, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PurchaseCorrectiveInvoicesApi->getPurchaseCorrectiveInvoices: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **show_payments_allocations** | **bool**| Use this to show the artefact&#39;s payments and allocations | [optional]
 **search** | **string**| Use this to filter by the invoice reference or contact name. | [optional]
 **contact_id** | **string**| Use this to filter by contact id | [optional]
 **status_id** | **string**| Use this to filter by status id | [optional]
 **from_date** | **\DateTime**| Use this to filter by Purchase Corrective Invoices dates | [optional]
 **to_date** | **\DateTime**| Use this to filter by Purchase Corrective Invoices dates | [optional]
 **updated_or_created_since** | **\DateTime**| Use this to limit the response to Purchase Corrective Invoices changed since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Inclusive of the passed timestamp. | [optional]
 **deleted_since** | **\DateTime**| Use this to limit the response to Purchase Corrective Invoices deleted since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Not inclusive of the passed timestamp. | [optional]
 **show_legacy_id** | **bool**| Display the legacy_id for the Purchase Corrective Invoices. | [optional]
 **items_per_page** | **int**| Returns the given number of Purchase Corrective Invoices per request. | [optional] [default to 20]
 **page** | **int**| Go to specific page of Purchase Corrective Invoices | [optional] [default to 1]
 **attributes** | **string**| Specify the attributes that you want to expose for the Purchase Corrective Invoices (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\PurchaseCorrectiveInvoice[]**](../Model/PurchaseCorrectiveInvoice.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getPurchaseCorrectiveInvoicesKey()`

```php
getPurchaseCorrectiveInvoicesKey($key, $show_payments_allocations, $nested_attributes, $show_legacy_id, $attributes): \SageOne\Model\PurchaseCorrectiveInvoice
```

Returns a Purchase Corrective Invoice

Returns a Purchase Corrective Invoice

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\PurchaseCorrectiveInvoicesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Purchase Corrective Invoice Key.
$show_payments_allocations = True; // bool | Use this to show the artefact's payments and allocations
$nested_attributes = 'nested_attributes_example'; // string | Specify the attributes that you want to expose for nested entities of the Purchase Corrective Invoice (expose all nested attributes with 'all'). These are in addition to the base attributes (name, path)
$show_legacy_id = True; // bool | Display the legacy_id for the Purchase Corrective Invoice.
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Purchase Corrective Invoice (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getPurchaseCorrectiveInvoicesKey($key, $show_payments_allocations, $nested_attributes, $show_legacy_id, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PurchaseCorrectiveInvoicesApi->getPurchaseCorrectiveInvoicesKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Purchase Corrective Invoice Key. |
 **show_payments_allocations** | **bool**| Use this to show the artefact&#39;s payments and allocations | [optional]
 **nested_attributes** | **string**| Specify the attributes that you want to expose for nested entities of the Purchase Corrective Invoice (expose all nested attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]
 **show_legacy_id** | **bool**| Display the legacy_id for the Purchase Corrective Invoice. | [optional]
 **attributes** | **string**| Specify the attributes that you want to expose for the Purchase Corrective Invoice (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\PurchaseCorrectiveInvoice**](../Model/PurchaseCorrectiveInvoice.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `postPurchaseCorrectiveInvoices()`

```php
postPurchaseCorrectiveInvoices($purchase_corrective_invoices): \SageOne\Model\PurchaseCorrectiveInvoice
```

Creates a Purchase Corrective Invoice

Creates a Purchase Corrective Invoice

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\PurchaseCorrectiveInvoicesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$purchase_corrective_invoices = new \SageOne\Model\PostPurchaseCorrectiveInvoices(); // \SageOne\Model\PostPurchaseCorrectiveInvoices

try {
    $result = $apiInstance->postPurchaseCorrectiveInvoices($purchase_corrective_invoices);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PurchaseCorrectiveInvoicesApi->postPurchaseCorrectiveInvoices: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **purchase_corrective_invoices** | [**\SageOne\Model\PostPurchaseCorrectiveInvoices**](../Model/PostPurchaseCorrectiveInvoices.md)|  |

### Return type

[**\SageOne\Model\PurchaseCorrectiveInvoice**](../Model/PurchaseCorrectiveInvoice.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `putPurchaseCorrectiveInvoicesKey()`

```php
putPurchaseCorrectiveInvoicesKey($key, $purchase_corrective_invoices): \SageOne\Model\PurchaseCorrectiveInvoice
```

Updates a Purchase Corrective Invoice

Updates a Purchase Corrective Invoice

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\PurchaseCorrectiveInvoicesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Purchase Corrective Invoice Key.
$purchase_corrective_invoices = new \SageOne\Model\PutPurchaseCorrectiveInvoices(); // \SageOne\Model\PutPurchaseCorrectiveInvoices

try {
    $result = $apiInstance->putPurchaseCorrectiveInvoicesKey($key, $purchase_corrective_invoices);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PurchaseCorrectiveInvoicesApi->putPurchaseCorrectiveInvoicesKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Purchase Corrective Invoice Key. |
 **purchase_corrective_invoices** | [**\SageOne\Model\PutPurchaseCorrectiveInvoices**](../Model/PutPurchaseCorrectiveInvoices.md)|  |

### Return type

[**\SageOne\Model\PurchaseCorrectiveInvoice**](../Model/PurchaseCorrectiveInvoice.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
