# SageOne\ProductsApi

All URIs are relative to https://api.accounting.sage.com/v3.1.

Method | HTTP request | Description
------------- | ------------- | -------------
[**deleteProductsKey()**](ProductsApi.md#deleteProductsKey) | **DELETE** /products/{key} | Deletes a Product
[**getProducts()**](ProductsApi.md#getProducts) | **GET** /products | Returns all Products
[**getProductsKey()**](ProductsApi.md#getProductsKey) | **GET** /products/{key} | Returns a Product
[**postProducts()**](ProductsApi.md#postProducts) | **POST** /products | Creates a Product
[**putProductsKey()**](ProductsApi.md#putProductsKey) | **PUT** /products/{key} | Updates a Product


## `deleteProductsKey()`

```php
deleteProductsKey($key)
```

Deletes a Product

Deletes a Product

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\ProductsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Product Key.

try {
    $apiInstance->deleteProductsKey($key);
} catch (Exception $e) {
    echo 'Exception when calling ProductsApi->deleteProductsKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Product Key. |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getProducts()`

```php
getProducts($search, $updated_or_created_since, $deleted_since, $active, $show_legacy_id, $items_per_page, $page, $attributes): \SageOne\Model\PagingProduct
```

Returns all Products

Returns all Products

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\ProductsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$search = 'search_example'; // string | Use this to filter by the item code or description.
$updated_or_created_since = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | Use this to limit the response to Products changed since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Inclusive of the passed timestamp.
$deleted_since = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | Use this to limit the response to Products deleted since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Not inclusive of the passed timestamp.
$active = True; // bool | Use this to only return active or inactive items
$show_legacy_id = True; // bool | Display the legacy_id for the Products.
$items_per_page = 20; // int | Returns the given number of Products per request.
$page = 1; // int | Go to specific page of Products
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Products (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getProducts($search, $updated_or_created_since, $deleted_since, $active, $show_legacy_id, $items_per_page, $page, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductsApi->getProducts: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **search** | **string**| Use this to filter by the item code or description. | [optional]
 **updated_or_created_since** | **\DateTime**| Use this to limit the response to Products changed since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Inclusive of the passed timestamp. | [optional]
 **deleted_since** | **\DateTime**| Use this to limit the response to Products deleted since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Not inclusive of the passed timestamp. | [optional]
 **active** | **bool**| Use this to only return active or inactive items | [optional]
 **show_legacy_id** | **bool**| Display the legacy_id for the Products. | [optional]
 **items_per_page** | **int**| Returns the given number of Products per request. | [optional] [default to 20]
 **page** | **int**| Go to specific page of Products | [optional] [default to 1]
 **attributes** | **string**| Specify the attributes that you want to expose for the Products (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\PagingProduct**](../Model/PagingProduct.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getProductsKey()`

```php
getProductsKey($key, $show_legacy_id, $attributes): \SageOne\Model\Product
```

Returns a Product

Returns a Product

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\ProductsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Product Key.
$show_legacy_id = True; // bool | Display the legacy_id for the Product.
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Product (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getProductsKey($key, $show_legacy_id, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductsApi->getProductsKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Product Key. |
 **show_legacy_id** | **bool**| Display the legacy_id for the Product. | [optional]
 **attributes** | **string**| Specify the attributes that you want to expose for the Product (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\Product**](../Model/Product.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `postProducts()`

```php
postProducts($products): \SageOne\Model\Product
```

Creates a Product

Creates a Product

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\ProductsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$products = new \SageOne\Model\PostProducts(); // \SageOne\Model\PostProducts

try {
    $result = $apiInstance->postProducts($products);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductsApi->postProducts: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **products** | [**\SageOne\Model\PostProducts**](../Model/PostProducts.md)|  |

### Return type

[**\SageOne\Model\Product**](../Model/Product.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `putProductsKey()`

```php
putProductsKey($key, $products): \SageOne\Model\Product
```

Updates a Product

Updates a Product

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\ProductsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Product Key.
$products = new \SageOne\Model\PutProducts(); // \SageOne\Model\PutProducts

try {
    $result = $apiInstance->putProductsKey($key, $products);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductsApi->putProductsKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Product Key. |
 **products** | [**\SageOne\Model\PutProducts**](../Model/PutProducts.md)|  |

### Return type

[**\SageOne\Model\Product**](../Model/Product.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
