# SageOne\ProductSalesPriceTypesApi

All URIs are relative to https://api.accounting.sage.com/v3.1.

Method | HTTP request | Description
------------- | ------------- | -------------
[**deleteProductSalesPriceTypesKey()**](ProductSalesPriceTypesApi.md#deleteProductSalesPriceTypesKey) | **DELETE** /product_sales_price_types/{key} | Deletes a Product Sales Price Type
[**getProductSalesPriceTypes()**](ProductSalesPriceTypesApi.md#getProductSalesPriceTypes) | **GET** /product_sales_price_types | Returns all Product Sales Price Types
[**getProductSalesPriceTypesKey()**](ProductSalesPriceTypesApi.md#getProductSalesPriceTypesKey) | **GET** /product_sales_price_types/{key} | Returns a Product Sales Price Type
[**postProductSalesPriceTypes()**](ProductSalesPriceTypesApi.md#postProductSalesPriceTypes) | **POST** /product_sales_price_types | Creates a Product Sales Price Type
[**putProductSalesPriceTypesKey()**](ProductSalesPriceTypesApi.md#putProductSalesPriceTypesKey) | **PUT** /product_sales_price_types/{key} | Updates a Product Sales Price Type


## `deleteProductSalesPriceTypesKey()`

```php
deleteProductSalesPriceTypesKey($key)
```

Deletes a Product Sales Price Type

Deletes a Product Sales Price Type

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\ProductSalesPriceTypesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Product Sales Price Type Key.

try {
    $apiInstance->deleteProductSalesPriceTypesKey($key);
} catch (Exception $e) {
    echo 'Exception when calling ProductSalesPriceTypesApi->deleteProductSalesPriceTypesKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Product Sales Price Type Key. |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getProductSalesPriceTypes()`

```php
getProductSalesPriceTypes($active, $show_legacy_id, $items_per_page, $page, $attributes): \SageOne\Model\PagingProductSalesPriceType
```

Returns all Product Sales Price Types

Returns all Product Sales Price Types

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\ProductSalesPriceTypesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$active = True; // bool | Use this to only return active or inactive items
$show_legacy_id = True; // bool | Display the legacy_id for the Product Prices.
$items_per_page = 20; // int | Returns the given number of Product Prices per request.
$page = 1; // int | Go to specific page of Product Prices
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Product Prices (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getProductSalesPriceTypes($active, $show_legacy_id, $items_per_page, $page, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductSalesPriceTypesApi->getProductSalesPriceTypes: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **active** | **bool**| Use this to only return active or inactive items | [optional]
 **show_legacy_id** | **bool**| Display the legacy_id for the Product Prices. | [optional]
 **items_per_page** | **int**| Returns the given number of Product Prices per request. | [optional] [default to 20]
 **page** | **int**| Go to specific page of Product Prices | [optional] [default to 1]
 **attributes** | **string**| Specify the attributes that you want to expose for the Product Prices (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\PagingProductSalesPriceType**](../Model/PagingProductSalesPriceType.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getProductSalesPriceTypesKey()`

```php
getProductSalesPriceTypesKey($key, $show_legacy_id, $attributes): \SageOne\Model\ProductSalesPriceType
```

Returns a Product Sales Price Type

Returns a Product Sales Price Type

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\ProductSalesPriceTypesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Product Sales Price Type Key.
$show_legacy_id = True; // bool | Display the legacy_id for the Product Price.
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Product Price (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getProductSalesPriceTypesKey($key, $show_legacy_id, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductSalesPriceTypesApi->getProductSalesPriceTypesKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Product Sales Price Type Key. |
 **show_legacy_id** | **bool**| Display the legacy_id for the Product Price. | [optional]
 **attributes** | **string**| Specify the attributes that you want to expose for the Product Price (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\ProductSalesPriceType**](../Model/ProductSalesPriceType.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `postProductSalesPriceTypes()`

```php
postProductSalesPriceTypes($product_sales_price_types): \SageOne\Model\ProductSalesPriceType
```

Creates a Product Sales Price Type

Creates a Product Sales Price Type

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\ProductSalesPriceTypesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$product_sales_price_types = new \SageOne\Model\PostProductSalesPriceTypes(); // \SageOne\Model\PostProductSalesPriceTypes

try {
    $result = $apiInstance->postProductSalesPriceTypes($product_sales_price_types);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductSalesPriceTypesApi->postProductSalesPriceTypes: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **product_sales_price_types** | [**\SageOne\Model\PostProductSalesPriceTypes**](../Model/PostProductSalesPriceTypes.md)|  |

### Return type

[**\SageOne\Model\ProductSalesPriceType**](../Model/ProductSalesPriceType.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `putProductSalesPriceTypesKey()`

```php
putProductSalesPriceTypesKey($key, $product_sales_price_types): \SageOne\Model\ProductSalesPriceType
```

Updates a Product Sales Price Type

Updates a Product Sales Price Type

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\ProductSalesPriceTypesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Product Sales Price Type Key.
$product_sales_price_types = new \SageOne\Model\PutProductSalesPriceTypes(); // \SageOne\Model\PutProductSalesPriceTypes

try {
    $result = $apiInstance->putProductSalesPriceTypesKey($key, $product_sales_price_types);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductSalesPriceTypesApi->putProductSalesPriceTypesKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Product Sales Price Type Key. |
 **product_sales_price_types** | [**\SageOne\Model\PutProductSalesPriceTypes**](../Model/PutProductSalesPriceTypes.md)|  |

### Return type

[**\SageOne\Model\ProductSalesPriceType**](../Model/ProductSalesPriceType.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
