# SageOne\PaymentMethodsApi

All URIs are relative to https://api.accounting.sage.com/v3.1.

Method | HTTP request | Description
------------- | ------------- | -------------
[**getPaymentMethods()**](PaymentMethodsApi.md#getPaymentMethods) | **GET** /payment_methods | Returns all Payment Methods
[**getPaymentMethodsKey()**](PaymentMethodsApi.md#getPaymentMethodsKey) | **GET** /payment_methods/{key} | Returns a Payment Method


## `getPaymentMethods()`

```php
getPaymentMethods($show_legacy_id, $items_per_page, $page, $attributes): \SageOne\Model\PagingBase
```

Returns all Payment Methods

Returns all Payment Methods

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\PaymentMethodsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$show_legacy_id = True; // bool | Display the legacy_id for the Payment Types.
$items_per_page = 20; // int | Returns the given number of Payment Types per request.
$page = 1; // int | Go to specific page of Payment Types
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Payment Types (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getPaymentMethods($show_legacy_id, $items_per_page, $page, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PaymentMethodsApi->getPaymentMethods: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **show_legacy_id** | **bool**| Display the legacy_id for the Payment Types. | [optional]
 **items_per_page** | **int**| Returns the given number of Payment Types per request. | [optional] [default to 20]
 **page** | **int**| Go to specific page of Payment Types | [optional] [default to 1]
 **attributes** | **string**| Specify the attributes that you want to expose for the Payment Types (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\PagingBase**](../Model/PagingBase.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getPaymentMethodsKey()`

```php
getPaymentMethodsKey($key, $show_legacy_id, $attributes): \SageOne\Model\Base
```

Returns a Payment Method

Returns a Payment Method

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\PaymentMethodsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Payment Method Key.
$show_legacy_id = True; // bool | Display the legacy_id for the Payment Type.
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Payment Type (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getPaymentMethodsKey($key, $show_legacy_id, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PaymentMethodsApi->getPaymentMethodsKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Payment Method Key. |
 **show_legacy_id** | **bool**| Display the legacy_id for the Payment Type. | [optional]
 **attributes** | **string**| Specify the attributes that you want to expose for the Payment Type (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\Base**](../Model/Base.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
