# SageOne\OtherPaymentsApi

All URIs are relative to https://api.accounting.sage.com/v3.1.

Method | HTTP request | Description
------------- | ------------- | -------------
[**deleteOtherPaymentsKey()**](OtherPaymentsApi.md#deleteOtherPaymentsKey) | **DELETE** /other_payments/{key} | Deletes a Other Payment
[**getOtherPayments()**](OtherPaymentsApi.md#getOtherPayments) | **GET** /other_payments | Returns all Other Payments
[**getOtherPaymentsKey()**](OtherPaymentsApi.md#getOtherPaymentsKey) | **GET** /other_payments/{key} | Returns a Other Payment
[**postOtherPayments()**](OtherPaymentsApi.md#postOtherPayments) | **POST** /other_payments | Creates a Other Payment
[**putOtherPaymentsKey()**](OtherPaymentsApi.md#putOtherPaymentsKey) | **PUT** /other_payments/{key} | Updates a Other Payment


## `deleteOtherPaymentsKey()`

```php
deleteOtherPaymentsKey($key)
```

Deletes a Other Payment

Deletes a Other Payment

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\OtherPaymentsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Other Payment Key.

try {
    $apiInstance->deleteOtherPaymentsKey($key);
} catch (Exception $e) {
    echo 'Exception when calling OtherPaymentsApi->deleteOtherPaymentsKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Other Payment Key. |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getOtherPayments()`

```php
getOtherPayments($contact_id, $bank_account_id, $transaction_type_id, $updated_or_created_since, $deleted_since, $from_date, $to_date, $show_legacy_id, $items_per_page, $page, $attributes): \SageOne\Model\OtherPayment[]
```

Returns all Other Payments

Returns all Other Payments

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\OtherPaymentsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$contact_id = 'contact_id_example'; // string | Use this to filter by contact id
$bank_account_id = 'bank_account_id_example'; // string | Use this to filter by bank account id
$transaction_type_id = 'transaction_type_id_example'; // string | Use this to filter by transaction type id
$updated_or_created_since = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | Use this to limit the response to Payments changed since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Inclusive of the passed timestamp.
$deleted_since = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | Use this to limit the response to Payments deleted since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Not inclusive of the passed timestamp.
$from_date = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | Use this to filter by Payments dates
$to_date = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | Use this to filter by Payments dates
$show_legacy_id = True; // bool | Display the legacy_id for the Payments.
$items_per_page = 20; // int | Returns the given number of Payments per request.
$page = 1; // int | Go to specific page of Payments
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Payments (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getOtherPayments($contact_id, $bank_account_id, $transaction_type_id, $updated_or_created_since, $deleted_since, $from_date, $to_date, $show_legacy_id, $items_per_page, $page, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OtherPaymentsApi->getOtherPayments: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **contact_id** | **string**| Use this to filter by contact id | [optional]
 **bank_account_id** | **string**| Use this to filter by bank account id | [optional]
 **transaction_type_id** | **string**| Use this to filter by transaction type id | [optional]
 **updated_or_created_since** | **\DateTime**| Use this to limit the response to Payments changed since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Inclusive of the passed timestamp. | [optional]
 **deleted_since** | **\DateTime**| Use this to limit the response to Payments deleted since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Not inclusive of the passed timestamp. | [optional]
 **from_date** | **\DateTime**| Use this to filter by Payments dates | [optional]
 **to_date** | **\DateTime**| Use this to filter by Payments dates | [optional]
 **show_legacy_id** | **bool**| Display the legacy_id for the Payments. | [optional]
 **items_per_page** | **int**| Returns the given number of Payments per request. | [optional] [default to 20]
 **page** | **int**| Go to specific page of Payments | [optional] [default to 1]
 **attributes** | **string**| Specify the attributes that you want to expose for the Payments (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\OtherPayment[]**](../Model/OtherPayment.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getOtherPaymentsKey()`

```php
getOtherPaymentsKey($key, $nested_attributes, $show_legacy_id, $attributes): \SageOne\Model\OtherPayment
```

Returns a Other Payment

Returns a Other Payment

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\OtherPaymentsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Other Payment Key.
$nested_attributes = 'nested_attributes_example'; // string | Specify the attributes that you want to expose for nested entities of the Payment (expose all nested attributes with 'all'). These are in addition to the base attributes (name, path)
$show_legacy_id = True; // bool | Display the legacy_id for the Payment.
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Payment (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getOtherPaymentsKey($key, $nested_attributes, $show_legacy_id, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OtherPaymentsApi->getOtherPaymentsKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Other Payment Key. |
 **nested_attributes** | **string**| Specify the attributes that you want to expose for nested entities of the Payment (expose all nested attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]
 **show_legacy_id** | **bool**| Display the legacy_id for the Payment. | [optional]
 **attributes** | **string**| Specify the attributes that you want to expose for the Payment (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\OtherPayment**](../Model/OtherPayment.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `postOtherPayments()`

```php
postOtherPayments($other_payments): \SageOne\Model\OtherPayment
```

Creates a Other Payment

Creates a Other Payment

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\OtherPaymentsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$other_payments = new \SageOne\Model\PostOtherPayments(); // \SageOne\Model\PostOtherPayments

try {
    $result = $apiInstance->postOtherPayments($other_payments);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OtherPaymentsApi->postOtherPayments: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **other_payments** | [**\SageOne\Model\PostOtherPayments**](../Model/PostOtherPayments.md)|  |

### Return type

[**\SageOne\Model\OtherPayment**](../Model/OtherPayment.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `putOtherPaymentsKey()`

```php
putOtherPaymentsKey($key, $other_payments): \SageOne\Model\OtherPayment
```

Updates a Other Payment

Updates a Other Payment

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\OtherPaymentsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Other Payment Key.
$other_payments = new \SageOne\Model\PutOtherPayments(); // \SageOne\Model\PutOtherPayments

try {
    $result = $apiInstance->putOtherPaymentsKey($key, $other_payments);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OtherPaymentsApi->putOtherPaymentsKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Other Payment Key. |
 **other_payments** | [**\SageOne\Model\PutOtherPayments**](../Model/PutOtherPayments.md)|  |

### Return type

[**\SageOne\Model\OtherPayment**](../Model/OtherPayment.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
