# SageOne\OpeningBalanceJournalsApi

All URIs are relative to https://api.accounting.sage.com/v3.1.

Method | HTTP request | Description
------------- | ------------- | -------------
[**deleteOpeningBalanceJournalsKey()**](OpeningBalanceJournalsApi.md#deleteOpeningBalanceJournalsKey) | **DELETE** /opening_balance_journals/{key} | Deletes a Opening Balance Journal
[**getOpeningBalanceJournals()**](OpeningBalanceJournalsApi.md#getOpeningBalanceJournals) | **GET** /opening_balance_journals | Returns all Opening Balance Journals
[**getOpeningBalanceJournalsKey()**](OpeningBalanceJournalsApi.md#getOpeningBalanceJournalsKey) | **GET** /opening_balance_journals/{key} | Returns a Opening Balance Journal
[**postOpeningBalanceJournals()**](OpeningBalanceJournalsApi.md#postOpeningBalanceJournals) | **POST** /opening_balance_journals | Creates a Opening Balance Journal


## `deleteOpeningBalanceJournalsKey()`

```php
deleteOpeningBalanceJournalsKey($key)
```

Deletes a Opening Balance Journal

Deletes a Opening Balance Journal

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\OpeningBalanceJournalsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Opening Balance Journal Key.

try {
    $apiInstance->deleteOpeningBalanceJournalsKey($key);
} catch (Exception $e) {
    echo 'Exception when calling OpeningBalanceJournalsApi->deleteOpeningBalanceJournalsKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Opening Balance Journal Key. |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getOpeningBalanceJournals()`

```php
getOpeningBalanceJournals($show_legacy_id, $items_per_page, $page, $attributes): \SageOne\Model\OpeningBalanceJournal[]
```

Returns all Opening Balance Journals

Returns all Opening Balance Journals

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\OpeningBalanceJournalsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$show_legacy_id = True; // bool | Display the legacy_id for the Journal Opening Balances.
$items_per_page = 20; // int | Returns the given number of Journal Opening Balances per request.
$page = 1; // int | Go to specific page of Journal Opening Balances
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Journal Opening Balances (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getOpeningBalanceJournals($show_legacy_id, $items_per_page, $page, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OpeningBalanceJournalsApi->getOpeningBalanceJournals: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **show_legacy_id** | **bool**| Display the legacy_id for the Journal Opening Balances. | [optional]
 **items_per_page** | **int**| Returns the given number of Journal Opening Balances per request. | [optional] [default to 20]
 **page** | **int**| Go to specific page of Journal Opening Balances | [optional] [default to 1]
 **attributes** | **string**| Specify the attributes that you want to expose for the Journal Opening Balances (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\OpeningBalanceJournal[]**](../Model/OpeningBalanceJournal.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getOpeningBalanceJournalsKey()`

```php
getOpeningBalanceJournalsKey($key, $show_legacy_id, $attributes): \SageOne\Model\OpeningBalanceJournal
```

Returns a Opening Balance Journal

Returns a Opening Balance Journal

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\OpeningBalanceJournalsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Opening Balance Journal Key.
$show_legacy_id = True; // bool | Display the legacy_id for the Journal Opening Balance.
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Journal Opening Balance (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getOpeningBalanceJournalsKey($key, $show_legacy_id, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OpeningBalanceJournalsApi->getOpeningBalanceJournalsKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Opening Balance Journal Key. |
 **show_legacy_id** | **bool**| Display the legacy_id for the Journal Opening Balance. | [optional]
 **attributes** | **string**| Specify the attributes that you want to expose for the Journal Opening Balance (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\OpeningBalanceJournal**](../Model/OpeningBalanceJournal.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `postOpeningBalanceJournals()`

```php
postOpeningBalanceJournals($opening_balance_journals): \SageOne\Model\OpeningBalanceJournal
```

Creates a Opening Balance Journal

Creates a Opening Balance Journal

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\OpeningBalanceJournalsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$opening_balance_journals = new \SageOne\Model\PostOpeningBalanceJournals(); // \SageOne\Model\PostOpeningBalanceJournals

try {
    $result = $apiInstance->postOpeningBalanceJournals($opening_balance_journals);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OpeningBalanceJournalsApi->postOpeningBalanceJournals: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **opening_balance_journals** | [**\SageOne\Model\PostOpeningBalanceJournals**](../Model/PostOpeningBalanceJournals.md)|  |

### Return type

[**\SageOne\Model\OpeningBalanceJournal**](../Model/OpeningBalanceJournal.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
