# SageOne\MigrationsApi

All URIs are relative to https://api.accounting.sage.com/v3.1.

Method | HTTP request | Description
------------- | ------------- | -------------
[**getMigrations()**](MigrationsApi.md#getMigrations) | **GET** /migrations | Returns all Migrations
[**putMigrations()**](MigrationsApi.md#putMigrations) | **PUT** /migrations | Updates a Migrations


## `getMigrations()`

```php
getMigrations($show_legacy_id): \SageOne\Model\Migration
```

Returns all Migrations

Returns all Migrations

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\MigrationsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$show_legacy_id = True; // bool | Display the legacy_id for the Migrations.

try {
    $result = $apiInstance->getMigrations($show_legacy_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling MigrationsApi->getMigrations: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **show_legacy_id** | **bool**| Display the legacy_id for the Migrations. | [optional]

### Return type

[**\SageOne\Model\Migration**](../Model/Migration.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `putMigrations()`

```php
putMigrations($migrations): \SageOne\Model\Migration
```

Updates a Migrations

Updates a Migrations

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\MigrationsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$migrations = new \SageOne\Model\PutMigrations(); // \SageOne\Model\PutMigrations

try {
    $result = $apiInstance->putMigrations($migrations);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling MigrationsApi->putMigrations: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **migrations** | [**\SageOne\Model\PutMigrations**](../Model/PutMigrations.md)|  |

### Return type

[**\SageOne\Model\Migration**](../Model/Migration.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
