# SageOne\MigrationTaxReturnsApi

All URIs are relative to https://api.accounting.sage.com/v3.1.

Method | HTTP request | Description
------------- | ------------- | -------------
[**getMigrationTaxReturns()**](MigrationTaxReturnsApi.md#getMigrationTaxReturns) | **GET** /migration_tax_returns | Returns all Migration Tax Returns
[**getMigrationTaxReturnsKey()**](MigrationTaxReturnsApi.md#getMigrationTaxReturnsKey) | **GET** /migration_tax_returns/{key} | Returns a Migration Tax Return
[**postMigrationTaxReturns()**](MigrationTaxReturnsApi.md#postMigrationTaxReturns) | **POST** /migration_tax_returns | Creates a Migration Tax Return


## `getMigrationTaxReturns()`

```php
getMigrationTaxReturns($show_legacy_id, $items_per_page, $page, $attributes): \SageOne\Model\MigrationTaxReturn[]
```

Returns all Migration Tax Returns

Returns all Migration Tax Returns

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\MigrationTaxReturnsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$show_legacy_id = True; // bool | Display the legacy_id for the Migration Tax Returns.
$items_per_page = 20; // int | Returns the given number of Migration Tax Returns per request.
$page = 1; // int | Go to specific page of Migration Tax Returns
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Migration Tax Returns (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getMigrationTaxReturns($show_legacy_id, $items_per_page, $page, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling MigrationTaxReturnsApi->getMigrationTaxReturns: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **show_legacy_id** | **bool**| Display the legacy_id for the Migration Tax Returns. | [optional]
 **items_per_page** | **int**| Returns the given number of Migration Tax Returns per request. | [optional] [default to 20]
 **page** | **int**| Go to specific page of Migration Tax Returns | [optional] [default to 1]
 **attributes** | **string**| Specify the attributes that you want to expose for the Migration Tax Returns (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\MigrationTaxReturn[]**](../Model/MigrationTaxReturn.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getMigrationTaxReturnsKey()`

```php
getMigrationTaxReturnsKey($key, $show_legacy_id, $attributes): \SageOne\Model\MigrationTaxReturn
```

Returns a Migration Tax Return

Returns a Migration Tax Return

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\MigrationTaxReturnsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Migration Tax Return Key.
$show_legacy_id = True; // bool | Display the legacy_id for the Migration Tax Return.
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Migration Tax Return (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getMigrationTaxReturnsKey($key, $show_legacy_id, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling MigrationTaxReturnsApi->getMigrationTaxReturnsKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Migration Tax Return Key. |
 **show_legacy_id** | **bool**| Display the legacy_id for the Migration Tax Return. | [optional]
 **attributes** | **string**| Specify the attributes that you want to expose for the Migration Tax Return (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\MigrationTaxReturn**](../Model/MigrationTaxReturn.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `postMigrationTaxReturns()`

```php
postMigrationTaxReturns($migration_tax_returns): \SageOne\Model\MigrationTaxReturn
```

Creates a Migration Tax Return

Creates a Migration Tax Return

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\MigrationTaxReturnsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$migration_tax_returns = new \SageOne\Model\PostMigrationTaxReturns(); // \SageOne\Model\PostMigrationTaxReturns

try {
    $result = $apiInstance->postMigrationTaxReturns($migration_tax_returns);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling MigrationTaxReturnsApi->postMigrationTaxReturns: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **migration_tax_returns** | [**\SageOne\Model\PostMigrationTaxReturns**](../Model/PostMigrationTaxReturns.md)|  |

### Return type

[**\SageOne\Model\MigrationTaxReturn**](../Model/MigrationTaxReturn.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
