# SageOne\LiveExchangeRatesApi

All URIs are relative to https://api.accounting.sage.com/v3.1.

Method | HTTP request | Description
------------- | ------------- | -------------
[**getLiveExchangeRates()**](LiveExchangeRatesApi.md#getLiveExchangeRates) | **GET** /live_exchange_rates | Returns all Live Exchange Rates
[**getLiveExchangeRatesKey()**](LiveExchangeRatesApi.md#getLiveExchangeRatesKey) | **GET** /live_exchange_rates/{key} | Returns a Live Exchange Rate


## `getLiveExchangeRates()`

```php
getLiveExchangeRates($show_legacy_id, $items_per_page, $page, $attributes): \SageOne\Model\LiveExchangeRate[]
```

Returns all Live Exchange Rates

Returns all Live Exchange Rates

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\LiveExchangeRatesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$show_legacy_id = True; // bool | Display the legacy_id for the Currencies.
$items_per_page = 20; // int | Returns the given number of Currencies per request.
$page = 1; // int | Go to specific page of Currencies
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Currencies (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getLiveExchangeRates($show_legacy_id, $items_per_page, $page, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling LiveExchangeRatesApi->getLiveExchangeRates: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **show_legacy_id** | **bool**| Display the legacy_id for the Currencies. | [optional]
 **items_per_page** | **int**| Returns the given number of Currencies per request. | [optional] [default to 20]
 **page** | **int**| Go to specific page of Currencies | [optional] [default to 1]
 **attributes** | **string**| Specify the attributes that you want to expose for the Currencies (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\LiveExchangeRate[]**](../Model/LiveExchangeRate.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getLiveExchangeRatesKey()`

```php
getLiveExchangeRatesKey($key, $show_legacy_id, $attributes): \SageOne\Model\LiveExchangeRate
```

Returns a Live Exchange Rate

Returns a Live Exchange Rate

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\LiveExchangeRatesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Live Exchange Rate Key.
$show_legacy_id = True; // bool | Display the legacy_id for the Currency.
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Currency (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getLiveExchangeRatesKey($key, $show_legacy_id, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling LiveExchangeRatesApi->getLiveExchangeRatesKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Live Exchange Rate Key. |
 **show_legacy_id** | **bool**| Display the legacy_id for the Currency. | [optional]
 **attributes** | **string**| Specify the attributes that you want to expose for the Currency (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\LiveExchangeRate**](../Model/LiveExchangeRate.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
