# SageOne\LegalFormTypesApi

All URIs are relative to https://api.accounting.sage.com/v3.1.

Method | HTTP request | Description
------------- | ------------- | -------------
[**getLegalFormTypes()**](LegalFormTypesApi.md#getLegalFormTypes) | **GET** /legal_form_types | Returns all Legal Form Types
[**getLegalFormTypesKey()**](LegalFormTypesApi.md#getLegalFormTypesKey) | **GET** /legal_form_types/{key} | Returns a Legal Form Type


## `getLegalFormTypes()`

```php
getLegalFormTypes($show_legacy_id, $items_per_page, $page, $attributes): \SageOne\Model\LegalFormType[]
```

Returns all Legal Form Types

Returns all Legal Form Types

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\LegalFormTypesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$show_legacy_id = True; // bool | Display the legacy_id for the Business Classifications.
$items_per_page = 20; // int | Returns the given number of Business Classifications per request.
$page = 1; // int | Go to specific page of Business Classifications
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Business Classifications (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getLegalFormTypes($show_legacy_id, $items_per_page, $page, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling LegalFormTypesApi->getLegalFormTypes: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **show_legacy_id** | **bool**| Display the legacy_id for the Business Classifications. | [optional]
 **items_per_page** | **int**| Returns the given number of Business Classifications per request. | [optional] [default to 20]
 **page** | **int**| Go to specific page of Business Classifications | [optional] [default to 1]
 **attributes** | **string**| Specify the attributes that you want to expose for the Business Classifications (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\LegalFormType[]**](../Model/LegalFormType.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getLegalFormTypesKey()`

```php
getLegalFormTypesKey($key, $show_legacy_id, $attributes): \SageOne\Model\LegalFormType
```

Returns a Legal Form Type

Returns a Legal Form Type

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\LegalFormTypesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Legal Form Type Key.
$show_legacy_id = True; // bool | Display the legacy_id for the Business Classification.
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Business Classification (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getLegalFormTypesKey($key, $show_legacy_id, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling LegalFormTypesApi->getLegalFormTypesKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Legal Form Type Key. |
 **show_legacy_id** | **bool**| Display the legacy_id for the Business Classification. | [optional]
 **attributes** | **string**| Specify the attributes that you want to expose for the Business Classification (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\LegalFormType**](../Model/LegalFormType.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
