# SageOne\LedgerAccountsApi

All URIs are relative to https://api.accounting.sage.com/v3.1.

Method | HTTP request | Description
------------- | ------------- | -------------
[**getLedgerAccounts()**](LedgerAccountsApi.md#getLedgerAccounts) | **GET** /ledger_accounts | Returns all Ledger Accounts
[**getLedgerAccountsKey()**](LedgerAccountsApi.md#getLedgerAccountsKey) | **GET** /ledger_accounts/{key} | Returns a Ledger Account
[**postLedgerAccounts()**](LedgerAccountsApi.md#postLedgerAccounts) | **POST** /ledger_accounts | Creates a Ledger Account
[**putLedgerAccountsKey()**](LedgerAccountsApi.md#putLedgerAccountsKey) | **PUT** /ledger_accounts/{key} | Updates a Ledger Account


## `getLedgerAccounts()`

```php
getLedgerAccounts($updated_or_created_since, $visible_in, $ledger_account_classification_id, $show_balance_details, $exclude_deleted_entries, $from_date, $to_date, $search, $sort_order_from_user_setting, $show_legacy_id, $items_per_page, $page, $attributes, $ledger_account_type_id): \SageOne\Model\PagingLedgerAccount
```

Returns all Ledger Accounts

Returns all Ledger Accounts

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\LedgerAccountsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$updated_or_created_since = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | Use this to limit the response to Ledger Accounts changed since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Inclusive of the passed timestamp.
$visible_in = 'visible_in_example'; // string | Use this to limit the response to ledger account types visible in a specific area. Valid values are: banking, sales, expenses, other_payments, other_receipts, journals and reporting
$ledger_account_classification_id = 'ledger_account_classification_id_example'; // string | Use this to filter by ledger account classification id
$show_balance_details = True; // bool | Use this to display the balance details for ledger accounts between a date range (requires from_date and to_date).
$exclude_deleted_entries = True; // bool | Exclude deleted ledger entries.
$from_date = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | Calculate balances from this date.
$to_date = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | Calculate balances to this date.
$search = 'search_example'; // string | Use this to filter by the item code or description
$sort_order_from_user_setting = True; // bool | Use this to enable ordering ledger accounts according to user settings. Defaulted to 'false'.
$show_legacy_id = True; // bool | Display the legacy_id for the Ledger Accounts.
$items_per_page = 20; // int | Returns the given number of Ledger Accounts per request.
$page = 1; // int | Go to specific page of Ledger Accounts
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Ledger Accounts (expose all attributes with 'all'). These are in addition to the base attributes (name, path)
$ledger_account_type_id = 'ledger_account_type_id_example'; // string | Use this to filter by ledger account type id

try {
    $result = $apiInstance->getLedgerAccounts($updated_or_created_since, $visible_in, $ledger_account_classification_id, $show_balance_details, $exclude_deleted_entries, $from_date, $to_date, $search, $sort_order_from_user_setting, $show_legacy_id, $items_per_page, $page, $attributes, $ledger_account_type_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling LedgerAccountsApi->getLedgerAccounts: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **updated_or_created_since** | **\DateTime**| Use this to limit the response to Ledger Accounts changed since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Inclusive of the passed timestamp. | [optional]
 **visible_in** | **string**| Use this to limit the response to ledger account types visible in a specific area. Valid values are: banking, sales, expenses, other_payments, other_receipts, journals and reporting | [optional]
 **ledger_account_classification_id** | **string**| Use this to filter by ledger account classification id | [optional]
 **show_balance_details** | **bool**| Use this to display the balance details for ledger accounts between a date range (requires from_date and to_date). | [optional]
 **exclude_deleted_entries** | **bool**| Exclude deleted ledger entries. | [optional]
 **from_date** | **\DateTime**| Calculate balances from this date. | [optional]
 **to_date** | **\DateTime**| Calculate balances to this date. | [optional]
 **search** | **string**| Use this to filter by the item code or description | [optional]
 **sort_order_from_user_setting** | **bool**| Use this to enable ordering ledger accounts according to user settings. Defaulted to &#39;false&#39;. | [optional]
 **show_legacy_id** | **bool**| Display the legacy_id for the Ledger Accounts. | [optional]
 **items_per_page** | **int**| Returns the given number of Ledger Accounts per request. | [optional] [default to 20]
 **page** | **int**| Go to specific page of Ledger Accounts | [optional] [default to 1]
 **attributes** | **string**| Specify the attributes that you want to expose for the Ledger Accounts (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]
 **ledger_account_type_id** | **string**| Use this to filter by ledger account type id | [optional]

### Return type

[**\SageOne\Model\PagingLedgerAccount**](../Model/PagingLedgerAccount.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getLedgerAccountsKey()`

```php
getLedgerAccountsKey($key, $nested_attributes, $show_balance_details, $exclude_deleted_entries, $from_date, $to_date, $show_legacy_id, $attributes): \SageOne\Model\LedgerAccount
```

Returns a Ledger Account

Returns a Ledger Account

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\LedgerAccountsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Ledger Account Key.
$nested_attributes = 'nested_attributes_example'; // string | Specify the attributes that you want to expose for nested entities of the Ledger Account (expose all nested attributes with 'all'). These are in addition to the base attributes (name, path)
$show_balance_details = True; // bool | Use this to display the balance details for ledger accounts between a date range (requires from_date and to_date).
$exclude_deleted_entries = True; // bool | Exclude deleted ledger entries.
$from_date = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | Calculate balances from this date.
$to_date = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | Calculate balances to this date.
$show_legacy_id = True; // bool | Display the legacy_id for the Ledger Account.
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Ledger Account (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getLedgerAccountsKey($key, $nested_attributes, $show_balance_details, $exclude_deleted_entries, $from_date, $to_date, $show_legacy_id, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling LedgerAccountsApi->getLedgerAccountsKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Ledger Account Key. |
 **nested_attributes** | **string**| Specify the attributes that you want to expose for nested entities of the Ledger Account (expose all nested attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]
 **show_balance_details** | **bool**| Use this to display the balance details for ledger accounts between a date range (requires from_date and to_date). | [optional]
 **exclude_deleted_entries** | **bool**| Exclude deleted ledger entries. | [optional]
 **from_date** | **\DateTime**| Calculate balances from this date. | [optional]
 **to_date** | **\DateTime**| Calculate balances to this date. | [optional]
 **show_legacy_id** | **bool**| Display the legacy_id for the Ledger Account. | [optional]
 **attributes** | **string**| Specify the attributes that you want to expose for the Ledger Account (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\LedgerAccount**](../Model/LedgerAccount.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `postLedgerAccounts()`

```php
postLedgerAccounts($ledger_accounts): \SageOne\Model\LedgerAccount
```

Creates a Ledger Account

Creates a Ledger Account

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\LedgerAccountsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$ledger_accounts = new \SageOne\Model\PostLedgerAccounts(); // \SageOne\Model\PostLedgerAccounts

try {
    $result = $apiInstance->postLedgerAccounts($ledger_accounts);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling LedgerAccountsApi->postLedgerAccounts: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ledger_accounts** | [**\SageOne\Model\PostLedgerAccounts**](../Model/PostLedgerAccounts.md)|  |

### Return type

[**\SageOne\Model\LedgerAccount**](../Model/LedgerAccount.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `putLedgerAccountsKey()`

```php
putLedgerAccountsKey($key, $ledger_accounts): \SageOne\Model\LedgerAccount
```

Updates a Ledger Account

Updates a Ledger Account

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\LedgerAccountsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Ledger Account Key.
$ledger_accounts = new \SageOne\Model\PutLedgerAccounts(); // \SageOne\Model\PutLedgerAccounts

try {
    $result = $apiInstance->putLedgerAccountsKey($key, $ledger_accounts);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling LedgerAccountsApi->putLedgerAccountsKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Ledger Account Key. |
 **ledger_accounts** | [**\SageOne\Model\PutLedgerAccounts**](../Model/PutLedgerAccounts.md)|  |

### Return type

[**\SageOne\Model\LedgerAccount**](../Model/LedgerAccount.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
