# SageOne\LedgerAccountTypesApi

All URIs are relative to https://api.accounting.sage.com/v3.1.

Method | HTTP request | Description
------------- | ------------- | -------------
[**getLedgerAccountTypes()**](LedgerAccountTypesApi.md#getLedgerAccountTypes) | **GET** /ledger_account_types | Returns all Ledger Account Types
[**getLedgerAccountTypesKey()**](LedgerAccountTypesApi.md#getLedgerAccountTypesKey) | **GET** /ledger_account_types/{key} | Returns a Ledger Account Type


## `getLedgerAccountTypes()`

```php
getLedgerAccountTypes($ledger_account_classification_id, $show_legacy_id, $items_per_page, $page, $attributes): \SageOne\Model\Base[]
```

Returns all Ledger Account Types

Returns all Ledger Account Types

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\LedgerAccountTypesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$ledger_account_classification_id = 'ledger_account_classification_id_example'; // string | Use this to filter by ledger account classification id
$show_legacy_id = True; // bool | Display the legacy_id for the Ledger Account Types.
$items_per_page = 20; // int | Returns the given number of Ledger Account Types per request.
$page = 1; // int | Go to specific page of Ledger Account Types
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Ledger Account Types (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getLedgerAccountTypes($ledger_account_classification_id, $show_legacy_id, $items_per_page, $page, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling LedgerAccountTypesApi->getLedgerAccountTypes: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ledger_account_classification_id** | **string**| Use this to filter by ledger account classification id | [optional]
 **show_legacy_id** | **bool**| Display the legacy_id for the Ledger Account Types. | [optional]
 **items_per_page** | **int**| Returns the given number of Ledger Account Types per request. | [optional] [default to 20]
 **page** | **int**| Go to specific page of Ledger Account Types | [optional] [default to 1]
 **attributes** | **string**| Specify the attributes that you want to expose for the Ledger Account Types (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\Base[]**](../Model/Base.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getLedgerAccountTypesKey()`

```php
getLedgerAccountTypesKey($key, $show_legacy_id, $attributes): \SageOne\Model\Base
```

Returns a Ledger Account Type

Returns a Ledger Account Type

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\LedgerAccountTypesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Ledger Account Type Key.
$show_legacy_id = True; // bool | Display the legacy_id for the Ledger Account Type.
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Ledger Account Type (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getLedgerAccountTypesKey($key, $show_legacy_id, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling LedgerAccountTypesApi->getLedgerAccountTypesKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Ledger Account Type Key. |
 **show_legacy_id** | **bool**| Display the legacy_id for the Ledger Account Type. | [optional]
 **attributes** | **string**| Specify the attributes that you want to expose for the Ledger Account Type (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\Base**](../Model/Base.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
