# SageOne\LedgerAccountOpeningBalancesApi

All URIs are relative to https://api.accounting.sage.com/v3.1.

Method | HTTP request | Description
------------- | ------------- | -------------
[**deleteLedgerAccountOpeningBalancesKey()**](LedgerAccountOpeningBalancesApi.md#deleteLedgerAccountOpeningBalancesKey) | **DELETE** /ledger_account_opening_balances/{key} | Deletes a Ledger Account Opening Balance
[**getLedgerAccountOpeningBalances()**](LedgerAccountOpeningBalancesApi.md#getLedgerAccountOpeningBalances) | **GET** /ledger_account_opening_balances | Returns all Ledger Account Opening Balances
[**getLedgerAccountOpeningBalancesKey()**](LedgerAccountOpeningBalancesApi.md#getLedgerAccountOpeningBalancesKey) | **GET** /ledger_account_opening_balances/{key} | Returns a Ledger Account Opening Balance
[**postLedgerAccountOpeningBalances()**](LedgerAccountOpeningBalancesApi.md#postLedgerAccountOpeningBalances) | **POST** /ledger_account_opening_balances | Creates a Ledger Account Opening Balance
[**putLedgerAccountOpeningBalancesKey()**](LedgerAccountOpeningBalancesApi.md#putLedgerAccountOpeningBalancesKey) | **PUT** /ledger_account_opening_balances/{key} | Updates a Ledger Account Opening Balance


## `deleteLedgerAccountOpeningBalancesKey()`

```php
deleteLedgerAccountOpeningBalancesKey($key)
```

Deletes a Ledger Account Opening Balance

Deletes a Ledger Account Opening Balance

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\LedgerAccountOpeningBalancesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Ledger Account Opening Balance Key.

try {
    $apiInstance->deleteLedgerAccountOpeningBalancesKey($key);
} catch (Exception $e) {
    echo 'Exception when calling LedgerAccountOpeningBalancesApi->deleteLedgerAccountOpeningBalancesKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Ledger Account Opening Balance Key. |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getLedgerAccountOpeningBalances()`

```php
getLedgerAccountOpeningBalances($updated_or_created_since, $show_legacy_id, $items_per_page, $page, $attributes): \SageOne\Model\LedgerAccountOpeningBalance[]
```

Returns all Ledger Account Opening Balances

Returns all Ledger Account Opening Balances

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\LedgerAccountOpeningBalancesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$updated_or_created_since = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | Use this to limit the response to Journal Opening Balance Lines changed since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Inclusive of the passed timestamp.
$show_legacy_id = True; // bool | Display the legacy_id for the Journal Opening Balance Lines.
$items_per_page = 20; // int | Returns the given number of Journal Opening Balance Lines per request.
$page = 1; // int | Go to specific page of Journal Opening Balance Lines
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Journal Opening Balance Lines (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getLedgerAccountOpeningBalances($updated_or_created_since, $show_legacy_id, $items_per_page, $page, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling LedgerAccountOpeningBalancesApi->getLedgerAccountOpeningBalances: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **updated_or_created_since** | **\DateTime**| Use this to limit the response to Journal Opening Balance Lines changed since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Inclusive of the passed timestamp. | [optional]
 **show_legacy_id** | **bool**| Display the legacy_id for the Journal Opening Balance Lines. | [optional]
 **items_per_page** | **int**| Returns the given number of Journal Opening Balance Lines per request. | [optional] [default to 20]
 **page** | **int**| Go to specific page of Journal Opening Balance Lines | [optional] [default to 1]
 **attributes** | **string**| Specify the attributes that you want to expose for the Journal Opening Balance Lines (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\LedgerAccountOpeningBalance[]**](../Model/LedgerAccountOpeningBalance.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getLedgerAccountOpeningBalancesKey()`

```php
getLedgerAccountOpeningBalancesKey($key, $show_legacy_id, $attributes): \SageOne\Model\LedgerAccountOpeningBalance
```

Returns a Ledger Account Opening Balance

Returns a Ledger Account Opening Balance

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\LedgerAccountOpeningBalancesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Ledger Account Opening Balance Key.
$show_legacy_id = True; // bool | Display the legacy_id for the Journal Opening Balance Line.
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Journal Opening Balance Line (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getLedgerAccountOpeningBalancesKey($key, $show_legacy_id, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling LedgerAccountOpeningBalancesApi->getLedgerAccountOpeningBalancesKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Ledger Account Opening Balance Key. |
 **show_legacy_id** | **bool**| Display the legacy_id for the Journal Opening Balance Line. | [optional]
 **attributes** | **string**| Specify the attributes that you want to expose for the Journal Opening Balance Line (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\LedgerAccountOpeningBalance**](../Model/LedgerAccountOpeningBalance.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `postLedgerAccountOpeningBalances()`

```php
postLedgerAccountOpeningBalances($ledger_account_opening_balances): \SageOne\Model\LedgerAccountOpeningBalance
```

Creates a Ledger Account Opening Balance

Creates a Ledger Account Opening Balance

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\LedgerAccountOpeningBalancesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$ledger_account_opening_balances = new \SageOne\Model\PostLedgerAccountOpeningBalances(); // \SageOne\Model\PostLedgerAccountOpeningBalances

try {
    $result = $apiInstance->postLedgerAccountOpeningBalances($ledger_account_opening_balances);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling LedgerAccountOpeningBalancesApi->postLedgerAccountOpeningBalances: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ledger_account_opening_balances** | [**\SageOne\Model\PostLedgerAccountOpeningBalances**](../Model/PostLedgerAccountOpeningBalances.md)|  |

### Return type

[**\SageOne\Model\LedgerAccountOpeningBalance**](../Model/LedgerAccountOpeningBalance.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `putLedgerAccountOpeningBalancesKey()`

```php
putLedgerAccountOpeningBalancesKey($key, $ledger_account_opening_balances): \SageOne\Model\LedgerAccountOpeningBalance
```

Updates a Ledger Account Opening Balance

Updates a Ledger Account Opening Balance

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\LedgerAccountOpeningBalancesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Ledger Account Opening Balance Key.
$ledger_account_opening_balances = new \SageOne\Model\PutLedgerAccountOpeningBalances(); // \SageOne\Model\PutLedgerAccountOpeningBalances

try {
    $result = $apiInstance->putLedgerAccountOpeningBalancesKey($key, $ledger_account_opening_balances);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling LedgerAccountOpeningBalancesApi->putLedgerAccountOpeningBalancesKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Ledger Account Opening Balance Key. |
 **ledger_account_opening_balances** | [**\SageOne\Model\PutLedgerAccountOpeningBalances**](../Model/PutLedgerAccountOpeningBalances.md)|  |

### Return type

[**\SageOne\Model\LedgerAccountOpeningBalance**](../Model/LedgerAccountOpeningBalance.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
