# SageOne\JournalCodesApi

All URIs are relative to https://api.accounting.sage.com/v3.1.

Method | HTTP request | Description
------------- | ------------- | -------------
[**deleteJournalCodesKey()**](JournalCodesApi.md#deleteJournalCodesKey) | **DELETE** /journal_codes/{key} | Deletes a Journal Code
[**getJournalCodes()**](JournalCodesApi.md#getJournalCodes) | **GET** /journal_codes | Returns all Journal Codes
[**getJournalCodesKey()**](JournalCodesApi.md#getJournalCodesKey) | **GET** /journal_codes/{key} | Returns a Journal Code
[**postJournalCodes()**](JournalCodesApi.md#postJournalCodes) | **POST** /journal_codes | Creates a Journal Code
[**putJournalCodesKey()**](JournalCodesApi.md#putJournalCodesKey) | **PUT** /journal_codes/{key} | Updates a Journal Code


## `deleteJournalCodesKey()`

```php
deleteJournalCodesKey($key)
```

Deletes a Journal Code

Deletes a Journal Code

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\JournalCodesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Journal Code Key.

try {
    $apiInstance->deleteJournalCodesKey($key);
} catch (Exception $e) {
    echo 'Exception when calling JournalCodesApi->deleteJournalCodesKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Journal Code Key. |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getJournalCodes()`

```php
getJournalCodes($updated_or_created_since, $show_legacy_id, $items_per_page, $page, $attributes): \SageOne\Model\JournalCode[]
```

Returns all Journal Codes

Returns all Journal Codes

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\JournalCodesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$updated_or_created_since = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | Use this to limit the response to Journal Codes changed since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Inclusive of the passed timestamp.
$show_legacy_id = True; // bool | Display the legacy_id for the Journal Codes.
$items_per_page = 20; // int | Returns the given number of Journal Codes per request.
$page = 1; // int | Go to specific page of Journal Codes
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Journal Codes (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getJournalCodes($updated_or_created_since, $show_legacy_id, $items_per_page, $page, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling JournalCodesApi->getJournalCodes: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **updated_or_created_since** | **\DateTime**| Use this to limit the response to Journal Codes changed since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Inclusive of the passed timestamp. | [optional]
 **show_legacy_id** | **bool**| Display the legacy_id for the Journal Codes. | [optional]
 **items_per_page** | **int**| Returns the given number of Journal Codes per request. | [optional] [default to 20]
 **page** | **int**| Go to specific page of Journal Codes | [optional] [default to 1]
 **attributes** | **string**| Specify the attributes that you want to expose for the Journal Codes (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\JournalCode[]**](../Model/JournalCode.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getJournalCodesKey()`

```php
getJournalCodesKey($key, $show_legacy_id, $attributes): \SageOne\Model\JournalCode
```

Returns a Journal Code

Returns a Journal Code

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\JournalCodesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Journal Code Key.
$show_legacy_id = True; // bool | Display the legacy_id for the Journal Code.
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Journal Code (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getJournalCodesKey($key, $show_legacy_id, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling JournalCodesApi->getJournalCodesKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Journal Code Key. |
 **show_legacy_id** | **bool**| Display the legacy_id for the Journal Code. | [optional]
 **attributes** | **string**| Specify the attributes that you want to expose for the Journal Code (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\JournalCode**](../Model/JournalCode.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `postJournalCodes()`

```php
postJournalCodes($journal_codes): \SageOne\Model\JournalCode
```

Creates a Journal Code

Creates a Journal Code

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\JournalCodesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$journal_codes = new \SageOne\Model\PostJournalCodes(); // \SageOne\Model\PostJournalCodes

try {
    $result = $apiInstance->postJournalCodes($journal_codes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling JournalCodesApi->postJournalCodes: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **journal_codes** | [**\SageOne\Model\PostJournalCodes**](../Model/PostJournalCodes.md)|  |

### Return type

[**\SageOne\Model\JournalCode**](../Model/JournalCode.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `putJournalCodesKey()`

```php
putJournalCodesKey($key, $journal_codes): \SageOne\Model\JournalCode
```

Updates a Journal Code

Updates a Journal Code

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\JournalCodesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Journal Code Key.
$journal_codes = new \SageOne\Model\PutJournalCodes(); // \SageOne\Model\PutJournalCodes

try {
    $result = $apiInstance->putJournalCodesKey($key, $journal_codes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling JournalCodesApi->putJournalCodesKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Journal Code Key. |
 **journal_codes** | [**\SageOne\Model\PutJournalCodes**](../Model/PutJournalCodes.md)|  |

### Return type

[**\SageOne\Model\JournalCode**](../Model/JournalCode.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
