# SageOne\JournalCodeTypesApi

All URIs are relative to https://api.accounting.sage.com/v3.1.

Method | HTTP request | Description
------------- | ------------- | -------------
[**getJournalCodeTypes()**](JournalCodeTypesApi.md#getJournalCodeTypes) | **GET** /journal_code_types | Returns all Journal Code Types
[**getJournalCodeTypesKey()**](JournalCodeTypesApi.md#getJournalCodeTypesKey) | **GET** /journal_code_types/{key} | Returns a Journal Code Type


## `getJournalCodeTypes()`

```php
getJournalCodeTypes($show_legacy_id, $items_per_page, $page, $attributes): \SageOne\Model\JournalCodeType[]
```

Returns all Journal Code Types

Returns all Journal Code Types

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\JournalCodeTypesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$show_legacy_id = True; // bool | Display the legacy_id for the Country Journal Types.
$items_per_page = 20; // int | Returns the given number of Country Journal Types per request.
$page = 1; // int | Go to specific page of Country Journal Types
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Country Journal Types (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getJournalCodeTypes($show_legacy_id, $items_per_page, $page, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling JournalCodeTypesApi->getJournalCodeTypes: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **show_legacy_id** | **bool**| Display the legacy_id for the Country Journal Types. | [optional]
 **items_per_page** | **int**| Returns the given number of Country Journal Types per request. | [optional] [default to 20]
 **page** | **int**| Go to specific page of Country Journal Types | [optional] [default to 1]
 **attributes** | **string**| Specify the attributes that you want to expose for the Country Journal Types (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\JournalCodeType[]**](../Model/JournalCodeType.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getJournalCodeTypesKey()`

```php
getJournalCodeTypesKey($key, $show_legacy_id, $attributes): \SageOne\Model\JournalCodeType
```

Returns a Journal Code Type

Returns a Journal Code Type

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\JournalCodeTypesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Journal Code Type Key.
$show_legacy_id = True; // bool | Display the legacy_id for the Country Journal Type.
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Country Journal Type (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getJournalCodeTypesKey($key, $show_legacy_id, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling JournalCodeTypesApi->getJournalCodeTypesKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Journal Code Type Key. |
 **show_legacy_id** | **bool**| Display the legacy_id for the Country Journal Type. | [optional]
 **attributes** | **string**| Specify the attributes that you want to expose for the Country Journal Type (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\JournalCodeType**](../Model/JournalCodeType.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
