# SageOne\InvoiceSettingsApi

All URIs are relative to https://api.accounting.sage.com/v3.1.

Method | HTTP request | Description
------------- | ------------- | -------------
[**getInvoiceSettings()**](InvoiceSettingsApi.md#getInvoiceSettings) | **GET** /invoice_settings | Returns all Invoice Settings
[**putInvoiceSettings()**](InvoiceSettingsApi.md#putInvoiceSettings) | **PUT** /invoice_settings | Updates a Invoice Settings


## `getInvoiceSettings()`

```php
getInvoiceSettings($show_legacy_id): \SageOne\Model\InvoiceSettings
```

Returns all Invoice Settings

Returns all Invoice Settings

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\InvoiceSettingsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$show_legacy_id = True; // bool | Display the legacy_id for the Invoice Settings.

try {
    $result = $apiInstance->getInvoiceSettings($show_legacy_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InvoiceSettingsApi->getInvoiceSettings: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **show_legacy_id** | **bool**| Display the legacy_id for the Invoice Settings. | [optional]

### Return type

[**\SageOne\Model\InvoiceSettings**](../Model/InvoiceSettings.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `putInvoiceSettings()`

```php
putInvoiceSettings($invoice_settings): \SageOne\Model\InvoiceSettings
```

Updates a Invoice Settings

Updates a Invoice Settings

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\InvoiceSettingsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$invoice_settings = new \SageOne\Model\PutInvoiceSettings(); // \SageOne\Model\PutInvoiceSettings

try {
    $result = $apiInstance->putInvoiceSettings($invoice_settings);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InvoiceSettingsApi->putInvoiceSettings: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **invoice_settings** | [**\SageOne\Model\PutInvoiceSettings**](../Model/PutInvoiceSettings.md)|  |

### Return type

[**\SageOne\Model\InvoiceSettings**](../Model/InvoiceSettings.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
