# SageOne\HostedArtefactPaymentSettingsApi

All URIs are relative to https://api.accounting.sage.com/v3.1.

Method | HTTP request | Description
------------- | ------------- | -------------
[**deleteHostedArtefactPaymentSettingsKey()**](HostedArtefactPaymentSettingsApi.md#deleteHostedArtefactPaymentSettingsKey) | **DELETE** /hosted_artefact_payment_settings/{key} | Deletes a Hosted Artefact Payment Setting
[**getHostedArtefactPaymentSettings()**](HostedArtefactPaymentSettingsApi.md#getHostedArtefactPaymentSettings) | **GET** /hosted_artefact_payment_settings | Returns all Hosted Artefact Payment Settings
[**getHostedArtefactPaymentSettingsKey()**](HostedArtefactPaymentSettingsApi.md#getHostedArtefactPaymentSettingsKey) | **GET** /hosted_artefact_payment_settings/{key} | Returns a Hosted Artefact Payment Setting
[**postHostedArtefactPaymentSettings()**](HostedArtefactPaymentSettingsApi.md#postHostedArtefactPaymentSettings) | **POST** /hosted_artefact_payment_settings | Creates a Hosted Artefact Payment Setting


## `deleteHostedArtefactPaymentSettingsKey()`

```php
deleteHostedArtefactPaymentSettingsKey($key)
```

Deletes a Hosted Artefact Payment Setting

Deletes a Hosted Artefact Payment Setting

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\HostedArtefactPaymentSettingsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Hosted Artefact Payment Setting Key.

try {
    $apiInstance->deleteHostedArtefactPaymentSettingsKey($key);
} catch (Exception $e) {
    echo 'Exception when calling HostedArtefactPaymentSettingsApi->deleteHostedArtefactPaymentSettingsKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Hosted Artefact Payment Setting Key. |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getHostedArtefactPaymentSettings()`

```php
getHostedArtefactPaymentSettings($object_guid, $show_legacy_id, $items_per_page, $page, $attributes): \SageOne\Model\HostedArtefactPaymentSetting[]
```

Returns all Hosted Artefact Payment Settings

Returns all Hosted Artefact Payment Settings

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\HostedArtefactPaymentSettingsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$object_guid = 'object_guid_example'; // string | Use this to filter out hosted artefact payment settings by the guid of the object it is associated to.
$show_legacy_id = True; // bool | Display the legacy_id for the Hosted Artefact Payment Settings.
$items_per_page = 20; // int | Returns the given number of Hosted Artefact Payment Settings per request.
$page = 1; // int | Go to specific page of Hosted Artefact Payment Settings
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Hosted Artefact Payment Settings (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getHostedArtefactPaymentSettings($object_guid, $show_legacy_id, $items_per_page, $page, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling HostedArtefactPaymentSettingsApi->getHostedArtefactPaymentSettings: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **object_guid** | **string**| Use this to filter out hosted artefact payment settings by the guid of the object it is associated to. | [optional]
 **show_legacy_id** | **bool**| Display the legacy_id for the Hosted Artefact Payment Settings. | [optional]
 **items_per_page** | **int**| Returns the given number of Hosted Artefact Payment Settings per request. | [optional] [default to 20]
 **page** | **int**| Go to specific page of Hosted Artefact Payment Settings | [optional] [default to 1]
 **attributes** | **string**| Specify the attributes that you want to expose for the Hosted Artefact Payment Settings (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\HostedArtefactPaymentSetting[]**](../Model/HostedArtefactPaymentSetting.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getHostedArtefactPaymentSettingsKey()`

```php
getHostedArtefactPaymentSettingsKey($key, $show_legacy_id, $attributes): \SageOne\Model\HostedArtefactPaymentSetting
```

Returns a Hosted Artefact Payment Setting

Returns a Hosted Artefact Payment Setting

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\HostedArtefactPaymentSettingsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Hosted Artefact Payment Setting Key.
$show_legacy_id = True; // bool | Display the legacy_id for the Hosted Artefact Payment Setting.
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Hosted Artefact Payment Setting (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getHostedArtefactPaymentSettingsKey($key, $show_legacy_id, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling HostedArtefactPaymentSettingsApi->getHostedArtefactPaymentSettingsKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Hosted Artefact Payment Setting Key. |
 **show_legacy_id** | **bool**| Display the legacy_id for the Hosted Artefact Payment Setting. | [optional]
 **attributes** | **string**| Specify the attributes that you want to expose for the Hosted Artefact Payment Setting (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\HostedArtefactPaymentSetting**](../Model/HostedArtefactPaymentSetting.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `postHostedArtefactPaymentSettings()`

```php
postHostedArtefactPaymentSettings($hosted_artefact_payment_settings): \SageOne\Model\HostedArtefactPaymentSetting
```

Creates a Hosted Artefact Payment Setting

Creates a Hosted Artefact Payment Setting

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\HostedArtefactPaymentSettingsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$hosted_artefact_payment_settings = new \SageOne\Model\PostHostedArtefactPaymentSettings(); // \SageOne\Model\PostHostedArtefactPaymentSettings

try {
    $result = $apiInstance->postHostedArtefactPaymentSettings($hosted_artefact_payment_settings);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling HostedArtefactPaymentSettingsApi->postHostedArtefactPaymentSettings: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **hosted_artefact_payment_settings** | [**\SageOne\Model\PostHostedArtefactPaymentSettings**](../Model/PostHostedArtefactPaymentSettings.md)|  |

### Return type

[**\SageOne\Model\HostedArtefactPaymentSetting**](../Model/HostedArtefactPaymentSetting.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
