# SageOne\FinancialSettingsApi

All URIs are relative to https://api.accounting.sage.com/v3.1.

Method | HTTP request | Description
------------- | ------------- | -------------
[**getFinancialSettings()**](FinancialSettingsApi.md#getFinancialSettings) | **GET** /financial_settings | Returns all Financial Settings
[**putFinancialSettings()**](FinancialSettingsApi.md#putFinancialSettings) | **PUT** /financial_settings | Updates a Financial Settings


## `getFinancialSettings()`

```php
getFinancialSettings($show_legacy_id): \SageOne\Model\FinancialSettings
```

Returns all Financial Settings

Returns all Financial Settings

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\FinancialSettingsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$show_legacy_id = True; // bool | Display the legacy_id for the Financial Settings.

try {
    $result = $apiInstance->getFinancialSettings($show_legacy_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling FinancialSettingsApi->getFinancialSettings: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **show_legacy_id** | **bool**| Display the legacy_id for the Financial Settings. | [optional]

### Return type

[**\SageOne\Model\FinancialSettings**](../Model/FinancialSettings.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `putFinancialSettings()`

```php
putFinancialSettings($financial_settings): \SageOne\Model\FinancialSettings
```

Updates a Financial Settings

Updates a Financial Settings

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\FinancialSettingsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$financial_settings = new \SageOne\Model\PutFinancialSettings(); // \SageOne\Model\PutFinancialSettings

try {
    $result = $apiInstance->putFinancialSettings($financial_settings);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling FinancialSettingsApi->putFinancialSettings: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **financial_settings** | [**\SageOne\Model\PutFinancialSettings**](../Model/PutFinancialSettings.md)|  |

### Return type

[**\SageOne\Model\FinancialSettings**](../Model/FinancialSettings.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
