# SageOne\EuSalesDescriptionsApi

All URIs are relative to https://api.accounting.sage.com/v3.1.

Method | HTTP request | Description
------------- | ------------- | -------------
[**getEuSalesDescriptions()**](EuSalesDescriptionsApi.md#getEuSalesDescriptions) | **GET** /eu_sales_descriptions | Returns all Eu Sales Descriptions
[**getEuSalesDescriptionsKey()**](EuSalesDescriptionsApi.md#getEuSalesDescriptionsKey) | **GET** /eu_sales_descriptions/{key} | Returns a Eu Sales Description


## `getEuSalesDescriptions()`

```php
getEuSalesDescriptions($show_legacy_id, $items_per_page, $page, $attributes): \SageOne\Model\EuSalesDescription[]
```

Returns all Eu Sales Descriptions

Returns all Eu Sales Descriptions

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\EuSalesDescriptionsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$show_legacy_id = True; // bool | Display the legacy_id for the Ec Sales Descriptions.
$items_per_page = 20; // int | Returns the given number of Ec Sales Descriptions per request.
$page = 1; // int | Go to specific page of Ec Sales Descriptions
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Ec Sales Descriptions (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getEuSalesDescriptions($show_legacy_id, $items_per_page, $page, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling EuSalesDescriptionsApi->getEuSalesDescriptions: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **show_legacy_id** | **bool**| Display the legacy_id for the Ec Sales Descriptions. | [optional]
 **items_per_page** | **int**| Returns the given number of Ec Sales Descriptions per request. | [optional] [default to 20]
 **page** | **int**| Go to specific page of Ec Sales Descriptions | [optional] [default to 1]
 **attributes** | **string**| Specify the attributes that you want to expose for the Ec Sales Descriptions (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\EuSalesDescription[]**](../Model/EuSalesDescription.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getEuSalesDescriptionsKey()`

```php
getEuSalesDescriptionsKey($key, $show_legacy_id, $attributes): \SageOne\Model\EuSalesDescription
```

Returns a Eu Sales Description

Returns a Eu Sales Description

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\EuSalesDescriptionsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Eu Sales Description Key.
$show_legacy_id = True; // bool | Display the legacy_id for the Ec Sales Description.
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Ec Sales Description (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getEuSalesDescriptionsKey($key, $show_legacy_id, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling EuSalesDescriptionsApi->getEuSalesDescriptionsKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Eu Sales Description Key. |
 **show_legacy_id** | **bool**| Display the legacy_id for the Ec Sales Description. | [optional]
 **attributes** | **string**| Specify the attributes that you want to expose for the Ec Sales Description (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\EuSalesDescription**](../Model/EuSalesDescription.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
