# SageOne\EuGoodsServicesTypesApi

All URIs are relative to https://api.accounting.sage.com/v3.1.

Method | HTTP request | Description
------------- | ------------- | -------------
[**getEuGoodsServicesTypes()**](EuGoodsServicesTypesApi.md#getEuGoodsServicesTypes) | **GET** /eu_goods_services_types | Returns all Eu Goods Services Types
[**getEuGoodsServicesTypesKey()**](EuGoodsServicesTypesApi.md#getEuGoodsServicesTypesKey) | **GET** /eu_goods_services_types/{key} | Returns a Eu Goods Services Type


## `getEuGoodsServicesTypes()`

```php
getEuGoodsServicesTypes($show_legacy_id, $items_per_page, $page, $attributes): \SageOne\Model\Base[]
```

Returns all Eu Goods Services Types

Returns all Eu Goods Services Types

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\EuGoodsServicesTypesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$show_legacy_id = True; // bool | Display the legacy_id for the Eu Goods Services Types.
$items_per_page = 20; // int | Returns the given number of Eu Goods Services Types per request.
$page = 1; // int | Go to specific page of Eu Goods Services Types
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Eu Goods Services Types (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getEuGoodsServicesTypes($show_legacy_id, $items_per_page, $page, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling EuGoodsServicesTypesApi->getEuGoodsServicesTypes: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **show_legacy_id** | **bool**| Display the legacy_id for the Eu Goods Services Types. | [optional]
 **items_per_page** | **int**| Returns the given number of Eu Goods Services Types per request. | [optional] [default to 20]
 **page** | **int**| Go to specific page of Eu Goods Services Types | [optional] [default to 1]
 **attributes** | **string**| Specify the attributes that you want to expose for the Eu Goods Services Types (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\Base[]**](../Model/Base.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getEuGoodsServicesTypesKey()`

```php
getEuGoodsServicesTypesKey($key, $show_legacy_id, $attributes): \SageOne\Model\Base
```

Returns a Eu Goods Services Type

Returns a Eu Goods Services Type

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\EuGoodsServicesTypesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Eu Goods Services Type Key.
$show_legacy_id = True; // bool | Display the legacy_id for the Eu Goods Services Type.
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Eu Goods Services Type (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getEuGoodsServicesTypesKey($key, $show_legacy_id, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling EuGoodsServicesTypesApi->getEuGoodsServicesTypesKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Eu Goods Services Type Key. |
 **show_legacy_id** | **bool**| Display the legacy_id for the Eu Goods Services Type. | [optional]
 **attributes** | **string**| Specify the attributes that you want to expose for the Eu Goods Services Type (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\Base**](../Model/Base.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
