# SageOne\EmailSettingsApi

All URIs are relative to https://api.accounting.sage.com/v3.1.

Method | HTTP request | Description
------------- | ------------- | -------------
[**getEmailSettings()**](EmailSettingsApi.md#getEmailSettings) | **GET** /email_settings | Returns all Email Settings
[**putEmailSettings()**](EmailSettingsApi.md#putEmailSettings) | **PUT** /email_settings | Updates a Email Settings


## `getEmailSettings()`

```php
getEmailSettings($show_legacy_id): \SageOne\Model\EmailSettings
```

Returns all Email Settings

Returns all Email Settings

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\EmailSettingsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$show_legacy_id = True; // bool | Display the legacy_id for the Email Settings.

try {
    $result = $apiInstance->getEmailSettings($show_legacy_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling EmailSettingsApi->getEmailSettings: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **show_legacy_id** | **bool**| Display the legacy_id for the Email Settings. | [optional]

### Return type

[**\SageOne\Model\EmailSettings**](../Model/EmailSettings.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `putEmailSettings()`

```php
putEmailSettings($email_settings): \SageOne\Model\EmailSettings
```

Updates a Email Settings

Updates a Email Settings

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\EmailSettingsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$email_settings = new \SageOne\Model\PutEmailSettings(); // \SageOne\Model\PutEmailSettings

try {
    $result = $apiInstance->putEmailSettings($email_settings);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling EmailSettingsApi->putEmailSettings: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **email_settings** | [**\SageOne\Model\PutEmailSettings**](../Model/PutEmailSettings.md)|  |

### Return type

[**\SageOne\Model\EmailSettings**](../Model/EmailSettings.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
