# SageOne\DatevSettingsApi

All URIs are relative to https://api.accounting.sage.com/v3.1.

Method | HTTP request | Description
------------- | ------------- | -------------
[**getDatevSettings()**](DatevSettingsApi.md#getDatevSettings) | **GET** /datev_settings | Returns all Datev Settings
[**putDatevSettings()**](DatevSettingsApi.md#putDatevSettings) | **PUT** /datev_settings | Updates a Datev Settings


## `getDatevSettings()`

```php
getDatevSettings($show_legacy_id): \SageOne\Model\DatevSettings
```

Returns all Datev Settings

Returns all Datev Settings

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\DatevSettingsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$show_legacy_id = True; // bool | Display the legacy_id for the Datev Settings.

try {
    $result = $apiInstance->getDatevSettings($show_legacy_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling DatevSettingsApi->getDatevSettings: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **show_legacy_id** | **bool**| Display the legacy_id for the Datev Settings. | [optional]

### Return type

[**\SageOne\Model\DatevSettings**](../Model/DatevSettings.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `putDatevSettings()`

```php
putDatevSettings($datev_settings): \SageOne\Model\DatevSettings
```

Updates a Datev Settings

Updates a Datev Settings

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\DatevSettingsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$datev_settings = new \SageOne\Model\PutDatevSettings(); // \SageOne\Model\PutDatevSettings

try {
    $result = $apiInstance->putDatevSettings($datev_settings);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling DatevSettingsApi->putDatevSettings: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **datev_settings** | [**\SageOne\Model\PutDatevSettings**](../Model/PutDatevSettings.md)|  |

### Return type

[**\SageOne\Model\DatevSettings**](../Model/DatevSettings.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
