# SageOne\ContactsApi

All URIs are relative to https://api.accounting.sage.com/v3.1.

Method | HTTP request | Description
------------- | ------------- | -------------
[**deleteContactsKey()**](ContactsApi.md#deleteContactsKey) | **DELETE** /contacts/{key} | Deletes a Contact
[**getContacts()**](ContactsApi.md#getContacts) | **GET** /contacts | Returns all Contacts
[**getContactsKey()**](ContactsApi.md#getContactsKey) | **GET** /contacts/{key} | Returns a Contact
[**postContacts()**](ContactsApi.md#postContacts) | **POST** /contacts | Creates a Contact
[**putContactsKey()**](ContactsApi.md#putContactsKey) | **PUT** /contacts/{key} | Updates a Contact


## `deleteContactsKey()`

```php
deleteContactsKey($key)
```

Deletes a Contact

Deletes a Contact

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\ContactsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Contact Key.

try {
    $apiInstance->deleteContactsKey($key);
} catch (Exception $e) {
    echo 'Exception when calling ContactsApi->deleteContactsKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Contact Key. |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getContacts()`

```php
getContacts($updated_or_created_since, $deleted_since, $contact_type_id, $exclude_system, $search, $email, $nested_attributes, $show_balance, $show_legacy_id, $items_per_page, $page, $attributes): \SageOne\Model\PagingContact
```

Returns all Contacts

Returns all Contacts

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\ContactsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$updated_or_created_since = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | Use this to limit the response to Contacts changed since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Inclusive of the passed timestamp.
$deleted_since = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | Use this to limit the response to Contacts deleted since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Not inclusive of the passed timestamp.
$contact_type_id = 'contact_type_id_example'; // string | Use this to filter by contact type id
$exclude_system = True; // bool | Use this to filter out system entities, not applicable for transaction creation
$search = 'search_example'; // string | Use this to filter by the contact name, company name or reference.
$email = 'email_example'; // string | Use this to filter by the contact person email address.
$nested_attributes = 'nested_attributes_example'; // string | Specify the attributes that you want to expose for nested entities of the Contacts (expose all nested attributes with 'all'). These are in addition to the base attributes (name, path)
$show_balance = True; // bool | Use this to display the balance for a contact.
$show_legacy_id = True; // bool | Display the legacy_id for the Contacts.
$items_per_page = 20; // int | Returns the given number of Contacts per request.
$page = 1; // int | Go to specific page of Contacts
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Contacts (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getContacts($updated_or_created_since, $deleted_since, $contact_type_id, $exclude_system, $search, $email, $nested_attributes, $show_balance, $show_legacy_id, $items_per_page, $page, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContactsApi->getContacts: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **updated_or_created_since** | **\DateTime**| Use this to limit the response to Contacts changed since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Inclusive of the passed timestamp. | [optional]
 **deleted_since** | **\DateTime**| Use this to limit the response to Contacts deleted since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Not inclusive of the passed timestamp. | [optional]
 **contact_type_id** | **string**| Use this to filter by contact type id | [optional]
 **exclude_system** | **bool**| Use this to filter out system entities, not applicable for transaction creation | [optional]
 **search** | **string**| Use this to filter by the contact name, company name or reference. | [optional]
 **email** | **string**| Use this to filter by the contact person email address. | [optional]
 **nested_attributes** | **string**| Specify the attributes that you want to expose for nested entities of the Contacts (expose all nested attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]
 **show_balance** | **bool**| Use this to display the balance for a contact. | [optional]
 **show_legacy_id** | **bool**| Display the legacy_id for the Contacts. | [optional]
 **items_per_page** | **int**| Returns the given number of Contacts per request. | [optional] [default to 20]
 **page** | **int**| Go to specific page of Contacts | [optional] [default to 1]
 **attributes** | **string**| Specify the attributes that you want to expose for the Contacts (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\PagingContact**](../Model/PagingContact.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getContactsKey()`

```php
getContactsKey($key, $nested_attributes, $show_balance, $show_legacy_id, $attributes): \SageOne\Model\Contact
```

Returns a Contact

Returns a Contact

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\ContactsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Contact Key.
$nested_attributes = 'nested_attributes_example'; // string | Specify the attributes that you want to expose for nested entities of the Contact (expose all nested attributes with 'all'). These are in addition to the base attributes (name, path)
$show_balance = True; // bool | Use this to display the balance for a contact.
$show_legacy_id = True; // bool | Display the legacy_id for the Contact.
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Contact (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getContactsKey($key, $nested_attributes, $show_balance, $show_legacy_id, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContactsApi->getContactsKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Contact Key. |
 **nested_attributes** | **string**| Specify the attributes that you want to expose for nested entities of the Contact (expose all nested attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]
 **show_balance** | **bool**| Use this to display the balance for a contact. | [optional]
 **show_legacy_id** | **bool**| Display the legacy_id for the Contact. | [optional]
 **attributes** | **string**| Specify the attributes that you want to expose for the Contact (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\Contact**](../Model/Contact.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `postContacts()`

```php
postContacts($contacts): \SageOne\Model\Contact
```

Creates a Contact

Creates a Contact

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\ContactsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$contacts = new \SageOne\Model\PostContacts(); // \SageOne\Model\PostContacts

try {
    $result = $apiInstance->postContacts($contacts);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContactsApi->postContacts: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **contacts** | [**\SageOne\Model\PostContacts**](../Model/PostContacts.md)|  |

### Return type

[**\SageOne\Model\Contact**](../Model/Contact.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `putContactsKey()`

```php
putContactsKey($key, $contacts): \SageOne\Model\Contact
```

Updates a Contact

Updates a Contact

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\ContactsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Contact Key.
$contacts = new \SageOne\Model\PutContacts(); // \SageOne\Model\PutContacts

try {
    $result = $apiInstance->putContactsKey($key, $contacts);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContactsApi->putContactsKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Contact Key. |
 **contacts** | [**\SageOne\Model\PutContacts**](../Model/PutContacts.md)|  |

### Return type

[**\SageOne\Model\Contact**](../Model/Contact.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
