# SageOne\ContactPeopleApi

All URIs are relative to https://api.accounting.sage.com/v3.1.

Method | HTTP request | Description
------------- | ------------- | -------------
[**deleteContactPersonsKey()**](ContactPeopleApi.md#deleteContactPersonsKey) | **DELETE** /contact_persons/{key} | Deletes a Contact Person
[**getContactPersons()**](ContactPeopleApi.md#getContactPersons) | **GET** /contact_persons | Returns all Contact People
[**getContactPersonsKey()**](ContactPeopleApi.md#getContactPersonsKey) | **GET** /contact_persons/{key} | Returns a Contact Person
[**postContactPersons()**](ContactPeopleApi.md#postContactPersons) | **POST** /contact_persons | Creates a Contact Person
[**putContactPersonsKey()**](ContactPeopleApi.md#putContactPersonsKey) | **PUT** /contact_persons/{key} | Updates a Contact Person


## `deleteContactPersonsKey()`

```php
deleteContactPersonsKey($key)
```

Deletes a Contact Person

Deletes a Contact Person

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\ContactPeopleApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Contact Person Key.

try {
    $apiInstance->deleteContactPersonsKey($key);
} catch (Exception $e) {
    echo 'Exception when calling ContactPeopleApi->deleteContactPersonsKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Contact Person Key. |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getContactPersons()`

```php
getContactPersons($address_id, $updated_or_created_since, $deleted_since, $contact_id, $show_legacy_id, $items_per_page, $page, $attributes): \SageOne\Model\ContactPerson[]
```

Returns all Contact People

Returns all Contact People

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\ContactPeopleApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$address_id = 'address_id_example'; // string | Use this to filter by address id
$updated_or_created_since = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | Use this to limit the response to Address Contacts changed since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Inclusive of the passed timestamp.
$deleted_since = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | Use this to limit the response to Address Contacts deleted since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Not inclusive of the passed timestamp.
$contact_id = 'contact_id_example'; // string | Use this to filter by contact id
$show_legacy_id = True; // bool | Display the legacy_id for the Address Contacts.
$items_per_page = 20; // int | Returns the given number of Address Contacts per request.
$page = 1; // int | Go to specific page of Address Contacts
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Address Contacts (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getContactPersons($address_id, $updated_or_created_since, $deleted_since, $contact_id, $show_legacy_id, $items_per_page, $page, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContactPeopleApi->getContactPersons: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **address_id** | **string**| Use this to filter by address id | [optional]
 **updated_or_created_since** | **\DateTime**| Use this to limit the response to Address Contacts changed since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Inclusive of the passed timestamp. | [optional]
 **deleted_since** | **\DateTime**| Use this to limit the response to Address Contacts deleted since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Not inclusive of the passed timestamp. | [optional]
 **contact_id** | **string**| Use this to filter by contact id | [optional]
 **show_legacy_id** | **bool**| Display the legacy_id for the Address Contacts. | [optional]
 **items_per_page** | **int**| Returns the given number of Address Contacts per request. | [optional] [default to 20]
 **page** | **int**| Go to specific page of Address Contacts | [optional] [default to 1]
 **attributes** | **string**| Specify the attributes that you want to expose for the Address Contacts (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\ContactPerson[]**](../Model/ContactPerson.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getContactPersonsKey()`

```php
getContactPersonsKey($key, $nested_attributes, $show_legacy_id, $attributes): \SageOne\Model\ContactPerson
```

Returns a Contact Person

Returns a Contact Person

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\ContactPeopleApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Contact Person Key.
$nested_attributes = 'nested_attributes_example'; // string | Specify the attributes that you want to expose for nested entities of the Address Contact (expose all nested attributes with 'all'). These are in addition to the base attributes (name, path)
$show_legacy_id = True; // bool | Display the legacy_id for the Address Contact.
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Address Contact (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getContactPersonsKey($key, $nested_attributes, $show_legacy_id, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContactPeopleApi->getContactPersonsKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Contact Person Key. |
 **nested_attributes** | **string**| Specify the attributes that you want to expose for nested entities of the Address Contact (expose all nested attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]
 **show_legacy_id** | **bool**| Display the legacy_id for the Address Contact. | [optional]
 **attributes** | **string**| Specify the attributes that you want to expose for the Address Contact (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\ContactPerson**](../Model/ContactPerson.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `postContactPersons()`

```php
postContactPersons($contact_persons): \SageOne\Model\ContactPerson
```

Creates a Contact Person

Creates a Contact Person

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\ContactPeopleApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$contact_persons = new \SageOne\Model\PostContactPersons(); // \SageOne\Model\PostContactPersons

try {
    $result = $apiInstance->postContactPersons($contact_persons);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContactPeopleApi->postContactPersons: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **contact_persons** | [**\SageOne\Model\PostContactPersons**](../Model/PostContactPersons.md)|  |

### Return type

[**\SageOne\Model\ContactPerson**](../Model/ContactPerson.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `putContactPersonsKey()`

```php
putContactPersonsKey($key, $contact_persons): \SageOne\Model\ContactPerson
```

Updates a Contact Person

Updates a Contact Person

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\ContactPeopleApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Contact Person Key.
$contact_persons = new \SageOne\Model\PutContactPersons(); // \SageOne\Model\PutContactPersons

try {
    $result = $apiInstance->putContactPersonsKey($key, $contact_persons);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContactPeopleApi->putContactPersonsKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Contact Person Key. |
 **contact_persons** | [**\SageOne\Model\PutContactPersons**](../Model/PutContactPersons.md)|  |

### Return type

[**\SageOne\Model\ContactPerson**](../Model/ContactPerson.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
