# SageOne\ContactPaymentsApi

All URIs are relative to https://api.accounting.sage.com/v3.1.

Method | HTTP request | Description
------------- | ------------- | -------------
[**deleteContactPaymentsKey()**](ContactPaymentsApi.md#deleteContactPaymentsKey) | **DELETE** /contact_payments/{key} | Deletes a Contact Payment
[**getContactPayments()**](ContactPaymentsApi.md#getContactPayments) | **GET** /contact_payments | Returns all Contact Payments
[**getContactPaymentsKey()**](ContactPaymentsApi.md#getContactPaymentsKey) | **GET** /contact_payments/{key} | Returns a Contact Payment
[**postContactPayments()**](ContactPaymentsApi.md#postContactPayments) | **POST** /contact_payments | Creates a Contact Payment
[**putContactPaymentsKey()**](ContactPaymentsApi.md#putContactPaymentsKey) | **PUT** /contact_payments/{key} | Updates a Contact Payment


## `deleteContactPaymentsKey()`

```php
deleteContactPaymentsKey($key)
```

Deletes a Contact Payment

Deletes a Contact Payment

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\ContactPaymentsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Contact Payment Key.

try {
    $apiInstance->deleteContactPaymentsKey($key);
} catch (Exception $e) {
    echo 'Exception when calling ContactPaymentsApi->deleteContactPaymentsKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Contact Payment Key. |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getContactPayments()`

```php
getContactPayments($contact_id, $bank_account_id, $transaction_type_id, $updated_or_created_since, $deleted_since, $from_date, $to_date, $show_legacy_id, $items_per_page, $page, $attributes): \SageOne\Model\ContactPayment[]
```

Returns all Contact Payments

Returns all Contact Payments

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\ContactPaymentsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$contact_id = 'contact_id_example'; // string | Use this to filter by contact id
$bank_account_id = 'bank_account_id_example'; // string | Use this to filter by bank account id
$transaction_type_id = 'transaction_type_id_example'; // string | Use this to filter by transaction type id
$updated_or_created_since = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | Use this to limit the response to Artefact Payments changed since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Inclusive of the passed timestamp.
$deleted_since = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | Use this to limit the response to Artefact Payments deleted since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Not inclusive of the passed timestamp.
$from_date = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | Use this to filter by Artefact Payments dates
$to_date = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | Use this to filter by Artefact Payments dates
$show_legacy_id = True; // bool | Display the legacy_id for the Artefact Payments.
$items_per_page = 20; // int | Returns the given number of Artefact Payments per request.
$page = 1; // int | Go to specific page of Artefact Payments
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Artefact Payments (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getContactPayments($contact_id, $bank_account_id, $transaction_type_id, $updated_or_created_since, $deleted_since, $from_date, $to_date, $show_legacy_id, $items_per_page, $page, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContactPaymentsApi->getContactPayments: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **contact_id** | **string**| Use this to filter by contact id | [optional]
 **bank_account_id** | **string**| Use this to filter by bank account id | [optional]
 **transaction_type_id** | **string**| Use this to filter by transaction type id | [optional]
 **updated_or_created_since** | **\DateTime**| Use this to limit the response to Artefact Payments changed since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Inclusive of the passed timestamp. | [optional]
 **deleted_since** | **\DateTime**| Use this to limit the response to Artefact Payments deleted since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Not inclusive of the passed timestamp. | [optional]
 **from_date** | **\DateTime**| Use this to filter by Artefact Payments dates | [optional]
 **to_date** | **\DateTime**| Use this to filter by Artefact Payments dates | [optional]
 **show_legacy_id** | **bool**| Display the legacy_id for the Artefact Payments. | [optional]
 **items_per_page** | **int**| Returns the given number of Artefact Payments per request. | [optional] [default to 20]
 **page** | **int**| Go to specific page of Artefact Payments | [optional] [default to 1]
 **attributes** | **string**| Specify the attributes that you want to expose for the Artefact Payments (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\ContactPayment[]**](../Model/ContactPayment.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getContactPaymentsKey()`

```php
getContactPaymentsKey($key, $show_legacy_id, $attributes): \SageOne\Model\ContactPayment
```

Returns a Contact Payment

Returns a Contact Payment

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\ContactPaymentsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Contact Payment Key.
$show_legacy_id = True; // bool | Display the legacy_id for the Artefact Payment.
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Artefact Payment (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getContactPaymentsKey($key, $show_legacy_id, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContactPaymentsApi->getContactPaymentsKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Contact Payment Key. |
 **show_legacy_id** | **bool**| Display the legacy_id for the Artefact Payment. | [optional]
 **attributes** | **string**| Specify the attributes that you want to expose for the Artefact Payment (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\ContactPayment**](../Model/ContactPayment.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `postContactPayments()`

```php
postContactPayments($contact_payments): \SageOne\Model\ContactPayment
```

Creates a Contact Payment

Creates a Contact Payment

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\ContactPaymentsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$contact_payments = new \SageOne\Model\PostContactPayments(); // \SageOne\Model\PostContactPayments

try {
    $result = $apiInstance->postContactPayments($contact_payments);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContactPaymentsApi->postContactPayments: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **contact_payments** | [**\SageOne\Model\PostContactPayments**](../Model/PostContactPayments.md)|  |

### Return type

[**\SageOne\Model\ContactPayment**](../Model/ContactPayment.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `putContactPaymentsKey()`

```php
putContactPaymentsKey($key, $contact_payments): \SageOne\Model\ContactPayment
```

Updates a Contact Payment

Updates a Contact Payment

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\ContactPaymentsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Contact Payment Key.
$contact_payments = new \SageOne\Model\PutContactPayments(); // \SageOne\Model\PutContactPayments

try {
    $result = $apiInstance->putContactPaymentsKey($key, $contact_payments);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContactPaymentsApi->putContactPaymentsKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Contact Payment Key. |
 **contact_payments** | [**\SageOne\Model\PutContactPayments**](../Model/PutContactPayments.md)|  |

### Return type

[**\SageOne\Model\ContactPayment**](../Model/ContactPayment.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
