# SageOne\ContactOpeningBalancesApi

All URIs are relative to https://api.accounting.sage.com/v3.1.

Method | HTTP request | Description
------------- | ------------- | -------------
[**deleteContactOpeningBalancesKey()**](ContactOpeningBalancesApi.md#deleteContactOpeningBalancesKey) | **DELETE** /contact_opening_balances/{key} | Deletes a Contact Opening Balance
[**getContactOpeningBalances()**](ContactOpeningBalancesApi.md#getContactOpeningBalances) | **GET** /contact_opening_balances | Returns all Contact Opening Balances
[**getContactOpeningBalancesKey()**](ContactOpeningBalancesApi.md#getContactOpeningBalancesKey) | **GET** /contact_opening_balances/{key} | Returns a Contact Opening Balance
[**postContactOpeningBalances()**](ContactOpeningBalancesApi.md#postContactOpeningBalances) | **POST** /contact_opening_balances | Creates a Contact Opening Balance
[**putContactOpeningBalancesKey()**](ContactOpeningBalancesApi.md#putContactOpeningBalancesKey) | **PUT** /contact_opening_balances/{key} | Updates a Contact Opening Balance


## `deleteContactOpeningBalancesKey()`

```php
deleteContactOpeningBalancesKey($key)
```

Deletes a Contact Opening Balance

Deletes a Contact Opening Balance

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\ContactOpeningBalancesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Contact Opening Balance Key.

try {
    $apiInstance->deleteContactOpeningBalancesKey($key);
} catch (Exception $e) {
    echo 'Exception when calling ContactOpeningBalancesApi->deleteContactOpeningBalancesKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Contact Opening Balance Key. |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getContactOpeningBalances()`

```php
getContactOpeningBalances($updated_or_created_since, $deleted_since, $contact_type_id, $contact_id, $show_legacy_id, $items_per_page, $page, $attributes): \SageOne\Model\ContactOpeningBalance[]
```

Returns all Contact Opening Balances

Returns all Contact Opening Balances

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\ContactOpeningBalancesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$updated_or_created_since = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | Use this to limit the response to Batch Entries changed since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Inclusive of the passed timestamp.
$deleted_since = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | Use this to limit the response to Batch Entries deleted since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Not inclusive of the passed timestamp.
$contact_type_id = 'contact_type_id_example'; // string | Use this to filter by contact type id
$contact_id = 'contact_id_example'; // string | Use this to filter by contact id
$show_legacy_id = True; // bool | Display the legacy_id for the Batch Entries.
$items_per_page = 20; // int | Returns the given number of Batch Entries per request.
$page = 1; // int | Go to specific page of Batch Entries
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Batch Entries (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getContactOpeningBalances($updated_or_created_since, $deleted_since, $contact_type_id, $contact_id, $show_legacy_id, $items_per_page, $page, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContactOpeningBalancesApi->getContactOpeningBalances: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **updated_or_created_since** | **\DateTime**| Use this to limit the response to Batch Entries changed since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Inclusive of the passed timestamp. | [optional]
 **deleted_since** | **\DateTime**| Use this to limit the response to Batch Entries deleted since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Not inclusive of the passed timestamp. | [optional]
 **contact_type_id** | **string**| Use this to filter by contact type id | [optional]
 **contact_id** | **string**| Use this to filter by contact id | [optional]
 **show_legacy_id** | **bool**| Display the legacy_id for the Batch Entries. | [optional]
 **items_per_page** | **int**| Returns the given number of Batch Entries per request. | [optional] [default to 20]
 **page** | **int**| Go to specific page of Batch Entries | [optional] [default to 1]
 **attributes** | **string**| Specify the attributes that you want to expose for the Batch Entries (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\ContactOpeningBalance[]**](../Model/ContactOpeningBalance.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getContactOpeningBalancesKey()`

```php
getContactOpeningBalancesKey($key, $show_legacy_id, $attributes): \SageOne\Model\ContactOpeningBalance
```

Returns a Contact Opening Balance

Returns a Contact Opening Balance

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\ContactOpeningBalancesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Contact Opening Balance Key.
$show_legacy_id = True; // bool | Display the legacy_id for the Batch Entry.
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Batch Entry (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getContactOpeningBalancesKey($key, $show_legacy_id, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContactOpeningBalancesApi->getContactOpeningBalancesKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Contact Opening Balance Key. |
 **show_legacy_id** | **bool**| Display the legacy_id for the Batch Entry. | [optional]
 **attributes** | **string**| Specify the attributes that you want to expose for the Batch Entry (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\ContactOpeningBalance**](../Model/ContactOpeningBalance.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `postContactOpeningBalances()`

```php
postContactOpeningBalances($contact_opening_balances): \SageOne\Model\ContactOpeningBalance
```

Creates a Contact Opening Balance

Creates a Contact Opening Balance

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\ContactOpeningBalancesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$contact_opening_balances = new \SageOne\Model\PostContactOpeningBalances(); // \SageOne\Model\PostContactOpeningBalances

try {
    $result = $apiInstance->postContactOpeningBalances($contact_opening_balances);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContactOpeningBalancesApi->postContactOpeningBalances: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **contact_opening_balances** | [**\SageOne\Model\PostContactOpeningBalances**](../Model/PostContactOpeningBalances.md)|  |

### Return type

[**\SageOne\Model\ContactOpeningBalance**](../Model/ContactOpeningBalance.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `putContactOpeningBalancesKey()`

```php
putContactOpeningBalancesKey($key, $contact_opening_balances): \SageOne\Model\ContactOpeningBalance
```

Updates a Contact Opening Balance

Updates a Contact Opening Balance

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\ContactOpeningBalancesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Contact Opening Balance Key.
$contact_opening_balances = new \SageOne\Model\PutContactOpeningBalances(); // \SageOne\Model\PutContactOpeningBalances

try {
    $result = $apiInstance->putContactOpeningBalancesKey($key, $contact_opening_balances);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContactOpeningBalancesApi->putContactOpeningBalancesKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Contact Opening Balance Key. |
 **contact_opening_balances** | [**\SageOne\Model\PutContactOpeningBalances**](../Model/PutContactOpeningBalances.md)|  |

### Return type

[**\SageOne\Model\ContactOpeningBalance**](../Model/ContactOpeningBalance.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
