# SageOne\ContactOpeningBalanceTypesApi

All URIs are relative to https://api.accounting.sage.com/v3.1.

Method | HTTP request | Description
------------- | ------------- | -------------
[**getContactOpeningBalanceTypes()**](ContactOpeningBalanceTypesApi.md#getContactOpeningBalanceTypes) | **GET** /contact_opening_balance_types | Returns all Contact Opening Balance Types
[**getContactOpeningBalanceTypesKey()**](ContactOpeningBalanceTypesApi.md#getContactOpeningBalanceTypesKey) | **GET** /contact_opening_balance_types/{key} | Returns a Contact Opening Balance Type


## `getContactOpeningBalanceTypes()`

```php
getContactOpeningBalanceTypes($show_legacy_id, $items_per_page, $page, $attributes): \SageOne\Model\Base[]
```

Returns all Contact Opening Balance Types

Returns all Contact Opening Balance Types

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\ContactOpeningBalanceTypesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$show_legacy_id = True; // bool | Display the legacy_id for the Batch Entry Types.
$items_per_page = 20; // int | Returns the given number of Batch Entry Types per request.
$page = 1; // int | Go to specific page of Batch Entry Types
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Batch Entry Types (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getContactOpeningBalanceTypes($show_legacy_id, $items_per_page, $page, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContactOpeningBalanceTypesApi->getContactOpeningBalanceTypes: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **show_legacy_id** | **bool**| Display the legacy_id for the Batch Entry Types. | [optional]
 **items_per_page** | **int**| Returns the given number of Batch Entry Types per request. | [optional] [default to 20]
 **page** | **int**| Go to specific page of Batch Entry Types | [optional] [default to 1]
 **attributes** | **string**| Specify the attributes that you want to expose for the Batch Entry Types (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\Base[]**](../Model/Base.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getContactOpeningBalanceTypesKey()`

```php
getContactOpeningBalanceTypesKey($key, $show_legacy_id, $attributes): \SageOne\Model\Base
```

Returns a Contact Opening Balance Type

Returns a Contact Opening Balance Type

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\ContactOpeningBalanceTypesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Contact Opening Balance Type Key.
$show_legacy_id = True; // bool | Display the legacy_id for the Batch Entry Type.
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Batch Entry Type (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getContactOpeningBalanceTypesKey($key, $show_legacy_id, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContactOpeningBalanceTypesApi->getContactOpeningBalanceTypesKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Contact Opening Balance Type Key. |
 **show_legacy_id** | **bool**| Display the legacy_id for the Batch Entry Type. | [optional]
 **attributes** | **string**| Specify the attributes that you want to expose for the Batch Entry Type (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\Base**](../Model/Base.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
