# SageOne\ContactAllocationsApi

All URIs are relative to https://api.accounting.sage.com/v3.1.

Method | HTTP request | Description
------------- | ------------- | -------------
[**deleteContactAllocationsKey()**](ContactAllocationsApi.md#deleteContactAllocationsKey) | **DELETE** /contact_allocations/{key} | Deletes a Contact Allocation
[**getContactAllocations()**](ContactAllocationsApi.md#getContactAllocations) | **GET** /contact_allocations | Returns all Contact Allocations
[**getContactAllocationsKey()**](ContactAllocationsApi.md#getContactAllocationsKey) | **GET** /contact_allocations/{key} | Returns a Contact Allocation
[**postContactAllocations()**](ContactAllocationsApi.md#postContactAllocations) | **POST** /contact_allocations | Creates a Contact Allocation
[**putContactAllocationsKey()**](ContactAllocationsApi.md#putContactAllocationsKey) | **PUT** /contact_allocations/{key} | Updates a Contact Allocation


## `deleteContactAllocationsKey()`

```php
deleteContactAllocationsKey($key)
```

Deletes a Contact Allocation

Deletes a Contact Allocation

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\ContactAllocationsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Contact Allocation Key.

try {
    $apiInstance->deleteContactAllocationsKey($key);
} catch (Exception $e) {
    echo 'Exception when calling ContactAllocationsApi->deleteContactAllocationsKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Contact Allocation Key. |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getContactAllocations()`

```php
getContactAllocations($contact_id, $transaction_type_id, $updated_or_created_since, $deleted_since, $show_legacy_id, $items_per_page, $page, $attributes): \SageOne\Model\ContactAllocation[]
```

Returns all Contact Allocations

Returns all Contact Allocations

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\ContactAllocationsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$contact_id = 'contact_id_example'; // string | Use this to filter by contact id
$transaction_type_id = 'transaction_type_id_example'; // string | Use this to filter by transaction type id
$updated_or_created_since = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | Use this to limit the response to Allocations changed since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Inclusive of the passed timestamp.
$deleted_since = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | Use this to limit the response to Allocations deleted since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Not inclusive of the passed timestamp.
$show_legacy_id = True; // bool | Display the legacy_id for the Allocations.
$items_per_page = 20; // int | Returns the given number of Allocations per request.
$page = 1; // int | Go to specific page of Allocations
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Allocations (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getContactAllocations($contact_id, $transaction_type_id, $updated_or_created_since, $deleted_since, $show_legacy_id, $items_per_page, $page, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContactAllocationsApi->getContactAllocations: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **contact_id** | **string**| Use this to filter by contact id | [optional]
 **transaction_type_id** | **string**| Use this to filter by transaction type id | [optional]
 **updated_or_created_since** | **\DateTime**| Use this to limit the response to Allocations changed since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Inclusive of the passed timestamp. | [optional]
 **deleted_since** | **\DateTime**| Use this to limit the response to Allocations deleted since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Not inclusive of the passed timestamp. | [optional]
 **show_legacy_id** | **bool**| Display the legacy_id for the Allocations. | [optional]
 **items_per_page** | **int**| Returns the given number of Allocations per request. | [optional] [default to 20]
 **page** | **int**| Go to specific page of Allocations | [optional] [default to 1]
 **attributes** | **string**| Specify the attributes that you want to expose for the Allocations (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\ContactAllocation[]**](../Model/ContactAllocation.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getContactAllocationsKey()`

```php
getContactAllocationsKey($key, $attributes, $show_legacy_id): \SageOne\Model\ContactAllocation
```

Returns a Contact Allocation

Returns a Contact Allocation

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\ContactAllocationsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Contact Allocation Key.
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Allocation (expose all attributes with 'all'). These are in addition to the base attributes (name, path)
$show_legacy_id = True; // bool | Display the legacy_id for the Allocation.

try {
    $result = $apiInstance->getContactAllocationsKey($key, $attributes, $show_legacy_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContactAllocationsApi->getContactAllocationsKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Contact Allocation Key. |
 **attributes** | **string**| Specify the attributes that you want to expose for the Allocation (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]
 **show_legacy_id** | **bool**| Display the legacy_id for the Allocation. | [optional]

### Return type

[**\SageOne\Model\ContactAllocation**](../Model/ContactAllocation.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `postContactAllocations()`

```php
postContactAllocations($contact_allocations): \SageOne\Model\ContactAllocation
```

Creates a Contact Allocation

Creates a Contact Allocation

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\ContactAllocationsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$contact_allocations = new \SageOne\Model\PostContactAllocations(); // \SageOne\Model\PostContactAllocations

try {
    $result = $apiInstance->postContactAllocations($contact_allocations);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContactAllocationsApi->postContactAllocations: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **contact_allocations** | [**\SageOne\Model\PostContactAllocations**](../Model/PostContactAllocations.md)|  |

### Return type

[**\SageOne\Model\ContactAllocation**](../Model/ContactAllocation.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `putContactAllocationsKey()`

```php
putContactAllocationsKey($key, $contact_allocations): \SageOne\Model\ContactAllocation
```

Updates a Contact Allocation

Updates a Contact Allocation

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\ContactAllocationsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Contact Allocation Key.
$contact_allocations = new \SageOne\Model\PutContactAllocations(); // \SageOne\Model\PutContactAllocations

try {
    $result = $apiInstance->putContactAllocationsKey($key, $contact_allocations);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContactAllocationsApi->putContactAllocationsKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Contact Allocation Key. |
 **contact_allocations** | [**\SageOne\Model\PutContactAllocations**](../Model/PutContactAllocations.md)|  |

### Return type

[**\SageOne\Model\ContactAllocation**](../Model/ContactAllocation.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
