# SageOne\CoaTemplatesApi

All URIs are relative to https://api.accounting.sage.com/v3.1.

Method | HTTP request | Description
------------- | ------------- | -------------
[**getCoaTemplates()**](CoaTemplatesApi.md#getCoaTemplates) | **GET** /coa_templates | Returns all Coa Templates
[**getCoaTemplatesKey()**](CoaTemplatesApi.md#getCoaTemplatesKey) | **GET** /coa_templates/{key} | Returns a Coa Template


## `getCoaTemplates()`

```php
getCoaTemplates($show_legacy_id, $items_per_page, $page, $attributes, $country_id): \SageOne\Model\CoaTemplate[]
```

Returns all Coa Templates

Returns all Coa Templates

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\CoaTemplatesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$show_legacy_id = True; // bool | Display the legacy_id for the Coa Templates.
$items_per_page = 20; // int | Returns the given number of Coa Templates per request.
$page = 1; // int | Go to specific page of Coa Templates
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Coa Templates (expose all attributes with 'all'). These are in addition to the base attributes (name, path)
$country_id = 'country_id_example'; // string | Use this to filter by country id

try {
    $result = $apiInstance->getCoaTemplates($show_legacy_id, $items_per_page, $page, $attributes, $country_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CoaTemplatesApi->getCoaTemplates: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **show_legacy_id** | **bool**| Display the legacy_id for the Coa Templates. | [optional]
 **items_per_page** | **int**| Returns the given number of Coa Templates per request. | [optional] [default to 20]
 **page** | **int**| Go to specific page of Coa Templates | [optional] [default to 1]
 **attributes** | **string**| Specify the attributes that you want to expose for the Coa Templates (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]
 **country_id** | **string**| Use this to filter by country id | [optional]

### Return type

[**\SageOne\Model\CoaTemplate[]**](../Model/CoaTemplate.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getCoaTemplatesKey()`

```php
getCoaTemplatesKey($key, $show_legacy_id, $attributes): \SageOne\Model\CoaTemplate
```

Returns a Coa Template

Returns a Coa Template

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\CoaTemplatesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Coa Template Key.
$show_legacy_id = True; // bool | Display the legacy_id for the Coa Template.
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Coa Template (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getCoaTemplatesKey($key, $show_legacy_id, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CoaTemplatesApi->getCoaTemplatesKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Coa Template Key. |
 **show_legacy_id** | **bool**| Display the legacy_id for the Coa Template. | [optional]
 **attributes** | **string**| Specify the attributes that you want to expose for the Coa Template (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\CoaTemplate**](../Model/CoaTemplate.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
