# SageOne\CoaAccountsApi

All URIs are relative to https://api.accounting.sage.com/v3.1.

Method | HTTP request | Description
------------- | ------------- | -------------
[**getCoaAccounts()**](CoaAccountsApi.md#getCoaAccounts) | **GET** /coa_accounts | Returns all Coa Accounts
[**getCoaAccountsKey()**](CoaAccountsApi.md#getCoaAccountsKey) | **GET** /coa_accounts/{key} | Returns a Coa Account


## `getCoaAccounts()`

```php
getCoaAccounts($coa_template_id, $updated_or_created_since, $show_legacy_id, $items_per_page, $page, $attributes): \SageOne\Model\CoaAccount[]
```

Returns all Coa Accounts

Returns all Coa Accounts

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\CoaAccountsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$coa_template_id = 'coa_template_id_example'; // string | Use this to filter by COA Template
$updated_or_created_since = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | Use this to limit the response to Coa Accounts changed since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Inclusive of the passed timestamp.
$show_legacy_id = True; // bool | Display the legacy_id for the Coa Accounts.
$items_per_page = 20; // int | Returns the given number of Coa Accounts per request.
$page = 1; // int | Go to specific page of Coa Accounts
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Coa Accounts (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getCoaAccounts($coa_template_id, $updated_or_created_since, $show_legacy_id, $items_per_page, $page, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CoaAccountsApi->getCoaAccounts: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **coa_template_id** | **string**| Use this to filter by COA Template | [optional]
 **updated_or_created_since** | **\DateTime**| Use this to limit the response to Coa Accounts changed since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Inclusive of the passed timestamp. | [optional]
 **show_legacy_id** | **bool**| Display the legacy_id for the Coa Accounts. | [optional]
 **items_per_page** | **int**| Returns the given number of Coa Accounts per request. | [optional] [default to 20]
 **page** | **int**| Go to specific page of Coa Accounts | [optional] [default to 1]
 **attributes** | **string**| Specify the attributes that you want to expose for the Coa Accounts (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\CoaAccount[]**](../Model/CoaAccount.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getCoaAccountsKey()`

```php
getCoaAccountsKey($key, $show_legacy_id, $attributes): \SageOne\Model\CoaAccount
```

Returns a Coa Account

Returns a Coa Account

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\CoaAccountsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Coa Account Key.
$show_legacy_id = True; // bool | Display the legacy_id for the Coa Account.
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Coa Account (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getCoaAccountsKey($key, $show_legacy_id, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CoaAccountsApi->getCoaAccountsKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Coa Account Key. |
 **show_legacy_id** | **bool**| Display the legacy_id for the Coa Account. | [optional]
 **attributes** | **string**| Specify the attributes that you want to expose for the Coa Account (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\CoaAccount**](../Model/CoaAccount.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
