# SageOne\CatalogItemTypesApi

All URIs are relative to https://api.accounting.sage.com/v3.1.

Method | HTTP request | Description
------------- | ------------- | -------------
[**getCatalogItemTypes()**](CatalogItemTypesApi.md#getCatalogItemTypes) | **GET** /catalog_item_types | Returns all Catalog Item Types
[**getCatalogItemTypesKey()**](CatalogItemTypesApi.md#getCatalogItemTypesKey) | **GET** /catalog_item_types/{key} | Returns a Catalog Item Type


## `getCatalogItemTypes()`

```php
getCatalogItemTypes($show_legacy_id, $items_per_page, $page, $attributes): \SageOne\Model\Base[]
```

Returns all Catalog Item Types

Returns all Catalog Item Types

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\CatalogItemTypesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$show_legacy_id = True; // bool | Display the legacy_id for the Catalog Item Types.
$items_per_page = 20; // int | Returns the given number of Catalog Item Types per request.
$page = 1; // int | Go to specific page of Catalog Item Types
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Catalog Item Types (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getCatalogItemTypes($show_legacy_id, $items_per_page, $page, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CatalogItemTypesApi->getCatalogItemTypes: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **show_legacy_id** | **bool**| Display the legacy_id for the Catalog Item Types. | [optional]
 **items_per_page** | **int**| Returns the given number of Catalog Item Types per request. | [optional] [default to 20]
 **page** | **int**| Go to specific page of Catalog Item Types | [optional] [default to 1]
 **attributes** | **string**| Specify the attributes that you want to expose for the Catalog Item Types (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\Base[]**](../Model/Base.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getCatalogItemTypesKey()`

```php
getCatalogItemTypesKey($key, $show_legacy_id, $attributes): \SageOne\Model\Base
```

Returns a Catalog Item Type

Returns a Catalog Item Type

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\CatalogItemTypesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Catalog Item Type Key.
$show_legacy_id = True; // bool | Display the legacy_id for the Catalog Item Type.
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Catalog Item Type (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getCatalogItemTypesKey($key, $show_legacy_id, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CatalogItemTypesApi->getCatalogItemTypesKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Catalog Item Type Key. |
 **show_legacy_id** | **bool**| Display the legacy_id for the Catalog Item Type. | [optional]
 **attributes** | **string**| Specify the attributes that you want to expose for the Catalog Item Type (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\Base**](../Model/Base.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
